/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import me.shedaniel.architectury.utils.Value;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.screen.DisplayScreen;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroup;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupFluid;
import me.shedaniel.rei.jeicompat.ingredient.JEIGuiIngredientGroupItem;
import me.shedaniel.rei.jeicompat.wrap.JEIEntryDefinition;
import me.shedaniel.rei.jeicompat.wrap.JEIFocus;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiFluidStackGroup;
import mezz.jei.api.gui.ingredient.IGuiIngredientGroup;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JEIRecipeLayout<T>
implements IRecipeLayout {
    private final JEIWrappedCategory<T> category;
    private final JEIWrappedDisplay<T> display;
    private final Map<IIngredientType<?>, IGuiIngredientGroup<?>> groups = new HashMap();
    public final Value<IDrawable> background;

    public JEIRecipeLayout(JEIWrappedCategory<T> category, JEIWrappedDisplay<T> display, Value<IDrawable> background) {
        this.category = category;
        this.display = display;
        this.background = background;
    }

    @Override
    @NotNull
    public IGuiItemStackGroup getItemStacks() {
        return (IGuiItemStackGroup)this.getIngredientsGroup(VanillaTypes.ITEM);
    }

    @Override
    @NotNull
    public IGuiFluidStackGroup getFluidStacks() {
        return (IGuiFluidStackGroup)this.getIngredientsGroup(VanillaTypes.FLUID);
    }

    @Override
    @NotNull
    public <T> IGuiIngredientGroup<T> getIngredientsGroup(@NotNull IIngredientType<T> ingredientType) {
        return this.groups.computeIfAbsent(ingredientType, type -> {
            if (Objects.equals(type.getIngredientClass(), ItemStack.class)) {
                return new JEIGuiIngredientGroupItem(type.cast(), this.background);
            }
            if (Objects.equals(type.getIngredientClass(), FluidStack.class)) {
                return new JEIGuiIngredientGroupFluid(type.cast(), this.background);
            }
            return new JEIGuiIngredientGroup(type, this.background);
        });
    }

    @Override
    @Nullable
    public IFocus<?> getFocus() {
        DisplayScreen screen = (DisplayScreen)Minecraft.func_71410_x().field_71462_r;
        EntryStack<?> notice = screen.getIngredientStackToNotice();
        if (!notice.isEmpty()) {
            return new JEIFocus(IFocus.Mode.INPUT, JEIPluginDetector.unwrap(notice.cast())).wrap();
        }
        notice = screen.getResultStackToNotice();
        if (!notice.isEmpty()) {
            return new JEIFocus(IFocus.Mode.OUTPUT, JEIPluginDetector.unwrap(notice.cast())).wrap();
        }
        return null;
    }

    @Override
    @Nullable
    public <V> IFocus<V> getFocus(@NotNull IIngredientType<V> ingredientType) {
        return JEIFocus.cast(this.getFocus(), ingredientType);
    }

    @Override
    @NotNull
    public IRecipeCategory<?> getRecipeCategory() {
        return this.category.getBackingCategory();
    }

    @Override
    public void moveRecipeTransferButton(int posX, int posY) {
        throw JEIPluginDetector.TODO();
    }

    @Override
    public void setShapeless() {
        throw JEIPluginDetector.TODO();
    }

    public Map<IIngredientType<?>, IGuiIngredientGroup<?>> getGroups() {
        return this.groups;
    }

    public void addTo(List<Widget> widgets, Rectangle bounds) {
        for (Map.Entry<IIngredientType<?>, IGuiIngredientGroup<?>> groupEntry : this.getGroups().entrySet()) {
            JEIGuiIngredientGroup group = (JEIGuiIngredientGroup)groupEntry.getValue();
            Int2ObjectMap<JEIGuiIngredientGroup.SlotWrapper> guiIngredients = group.getGuiIngredients();
            IntArrayList integers = new IntArrayList((IntCollection)guiIngredients.keySet());
            integers.sort(Comparator.naturalOrder());
            IntListIterator intListIterator = integers.iterator();
            while (intListIterator.hasNext()) {
                int integer = (Integer)intListIterator.next();
                JEIGuiIngredientGroup.SlotWrapper wrapper = (JEIGuiIngredientGroup.SlotWrapper)guiIngredients.get(integer);
                wrapper.slot.getBounds().translate(bounds.x + 4, bounds.y + 4);
                wrapper.slot.highlightEnabled(!wrapper.isEmpty());
                if (wrapper.background != null) {
                    widgets.add(Widgets.wrapRenderer(wrapper.slot.getInnerBounds().clone(), JEIPluginDetector.wrapDrawable(wrapper.background)));
                }
                widgets.add(Widgets.withTranslate(wrapper.slot, 0.0, 0.0, 10.0));
                if (wrapper.renderer != null) {
                    JEIEntryDefinition.Renderer renderer = new JEIEntryDefinition.Renderer(wrapper.renderer);
                    for (EntryStack<?> entry : wrapper.slot.getEntries()) {
                        ClientEntryStacks.setRenderer(entry, renderer);
                    }
                } else if (wrapper.fluidCapacity == wrapper.fluidCapacity) {
                    for (EntryStack entryStack : wrapper.slot.getEntries()) {
                        if (entryStack.getType() != VanillaEntryTypes.FLUID) continue;
                        ClientEntryStacks.setFluidRenderRatio(entryStack.cast(), ((me.shedaniel.architectury.fluid.FluidStack)entryStack.cast().getValue()).getAmount().floatValue() / wrapper.fluidCapacity);
                    }
                }
                if (wrapper.overlay != null) {
                    widgets.add(Widgets.wrapRenderer(wrapper.slot.getInnerBounds().clone(), JEIPluginDetector.wrapDrawable(wrapper.overlay)));
                }
                List tooltipCallbacks = group.tooltipCallbacks;
                for (EntryStack<?> entry : wrapper.slot.getEntries()) {
                    ClientEntryStacks.setTooltipProcessor(entry, (stack, tooltip) -> {
                        Object ingredient = null;
                        for (ITooltipCallback callback : tooltipCallbacks) {
                            if (ingredient == null) {
                                ingredient = JEIPluginDetector.unwrap(stack);
                            }
                            callback.onTooltip(integer, wrapper.isInput(), ingredient, tooltip.getText());
                        }
                        return tooltip;
                    });
                }
            }
        }
    }
}

