/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.utils.Value;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIRecipeLayout;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedDisplay;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.LazyValue;
import net.minecraft.util.text.ITextComponent;
import org.jetbrains.annotations.Nullable;

public class JEIWrappedCategory<T>
implements DisplayCategory<JEIWrappedDisplay<T>> {
    private final IRecipeCategory<T> backingCategory;
    private final LazyValue<IDrawable> background;
    private final CategoryIdentifier<? extends JEIWrappedDisplay<T>> identifier;

    public JEIWrappedCategory(IRecipeCategory<T> backingCategory) {
        this.backingCategory = backingCategory;
        this.background = new LazyValue(backingCategory::getBackground);
        this.identifier = CategoryIdentifier.of(backingCategory.getUid());
    }

    public Class<? extends T> getRecipeClass() {
        return this.backingCategory.getRecipeClass();
    }

    public boolean handlesRecipe(T recipe) {
        return this.backingCategory.isHandled(recipe);
    }

    @Override
    public Renderer getIcon() {
        IDrawable icon = this.backingCategory.getIcon();
        if (icon != null) {
            return JEIPluginDetector.wrapDrawable(icon);
        }
        List<EntryIngredient> workstations = CategoryRegistry.getInstance().get(this.getCategoryIdentifier()).getWorkstations();
        if (!workstations.isEmpty()) {
            return Widgets.createSlot(new Point(0, 0)).entries(workstations.get(0)).disableBackground().disableHighlight().disableTooltips();
        }
        IReorderingProcessor title = this.getTitle().func_241878_f();
        final IReorderingProcessor titleTrimmed = sink -> title.accept((index, style, codepoint) -> {
            if (index == 0 || index == 1) {
                sink.accept(index, style, codepoint);
                return true;
            }
            return false;
        });
        return new Renderer(){

            @Override
            public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                font.func_238407_a_(matrices, titleTrimmed, (float)bounds.getCenterX() - (float)font.func_243245_a(titleTrimmed) / 2.0f, (float)bounds.getCenterY() - 4.5f, 0xFFFFFF);
            }

            @Override
            public int getZ() {
                return 0;
            }

            @Override
            public void setZ(int z) {
            }
        };
    }

    @Override
    public ITextComponent getTitle() {
        return new ImmutableTextComponent(this.backingCategory.getTitle());
    }

    @Override
    public int getDisplayWidth(JEIWrappedDisplay<T> display) {
        return ((IDrawable)this.background.func_179281_c()).getWidth() + 8;
    }

    @Override
    public CategoryIdentifier<? extends JEIWrappedDisplay<T>> getCategoryIdentifier() {
        return this.identifier;
    }

    @Override
    public int getDisplayHeight() {
        return ((IDrawable)this.background.func_179281_c()).getHeight() + 8;
    }

    public IRecipeCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    @Override
    public List<Widget> setupDisplay(final JEIWrappedDisplay<T> display, final Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add(Widgets.createRecipeBase(bounds));
        final IDrawable[] background = new IDrawable[]{(IDrawable)this.background.func_179281_c()};
        JEIRecipeLayout<T> layout = new JEIRecipeLayout<T>(this, display, new Value<IDrawable>(){

            public void accept(IDrawable iDrawable) {
                background[0] = iDrawable;
            }

            public IDrawable get() {
                return background[0];
            }
        });
        this.backingCategory.setRecipe(layout, display.getBackingRecipe(), display.getIngredients());
        widgets.add(Widgets.createDrawableWidget((helper, matrices, mouseX, mouseY, delta) -> background[0].draw(matrices, bounds.x + 4, bounds.y + 4)));
        widgets.add(new Widget(){

            public void func_230430_a_(MatrixStack arg, int i, int j, float f) {
                Tooltip tooltip;
                arg.func_227860_a_();
                arg.func_227861_a_((double)(bounds.x + 4), (double)(bounds.y + 4), (double)this.getZ());
                JEIWrappedCategory.this.backingCategory.draw(display.getBackingRecipe(), arg, i, j);
                arg.func_227865_b_();
                Point mouse = PointHelper.ofMouse();
                if (this.containsMouse(mouse) && (tooltip = this.getTooltip(mouse)) != null) {
                    tooltip.queue();
                }
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                List<ITextComponent> strings = JEIWrappedCategory.this.backingCategory.getTooltipStrings(display.getBackingRecipe(), mouse.x - bounds.x, mouse.y - bounds.y);
                if (strings.isEmpty()) {
                    return null;
                }
                return Tooltip.create(mouse, strings);
            }

            public List<? extends IGuiEventListener> func_231039_at__() {
                return Collections.emptyList();
            }

            public boolean func_231044_a_(double d, double e, int i) {
                return JEIWrappedCategory.this.backingCategory.handleClick(display.getBackingRecipe(), d - (double)bounds.x, e - (double)bounds.y, i) || super.func_231044_a_(d, e, i);
            }
        });
        layout.addTo(widgets, bounds);
        return widgets;
    }
}

