/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.jeicompat.wrap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.jeicompat.JEIPluginDetector;
import me.shedaniel.rei.jeicompat.wrap.JEIWrappedCategory;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.IIngredients;
import net.minecraft.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class JEIWrappedDisplay<T>
implements Display {
    private final JEIWrappedCategory<T> backingCategory;
    private final T backingRecipe;
    private final Map<IIngredientType<?>, List<? extends List<?>>> inputs = new HashMap();
    private final Map<IIngredientType<?>, List<? extends List<?>>> outputs = new HashMap();
    private final List<EntryIngredient> compiledInput = new ArrayList<EntryIngredient>();
    private final List<EntryIngredient> compiledOutputs = new ArrayList<EntryIngredient>();
    private final IIngredients ingredients;

    public JEIWrappedDisplay(JEIWrappedCategory<T> backingCategory, T backingRecipe) {
        this.backingCategory = backingCategory;
        this.backingRecipe = backingRecipe;
        this.ingredients = new IIngredients(){

            @Override
            public void setInputIngredients(@NotNull List<Ingredient> inputs) {
                this.setInputLists((IIngredientType)VanillaTypes.ITEM, CollectionUtils.map(inputs, ingredient -> Arrays.asList(ingredient.func_193365_a())));
            }

            public <R> void setInput(@NotNull IIngredientType<R> ingredientType, @NotNull R input) {
                List ingredient = JEIWrappedDisplay.this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.add(Collections.singletonList(input));
            }

            public <R> void setInputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> input) {
                List ingredient = JEIWrappedDisplay.this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.addAll(CollectionUtils.map(input, Collections::singletonList));
            }

            public <R> void setInputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> input) {
                List ingredient = JEIWrappedDisplay.this.inputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.addAll(input);
            }

            public <R> void setOutput(@NotNull IIngredientType<R> ingredientType, @NotNull R output) {
                List ingredient = JEIWrappedDisplay.this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.add(Collections.singletonList(output));
            }

            public <R> void setOutputs(@NotNull IIngredientType<R> ingredientType, @NotNull List<R> output) {
                List ingredient = JEIWrappedDisplay.this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.addAll(CollectionUtils.map(output, Collections::singletonList));
            }

            public <R> void setOutputLists(@NotNull IIngredientType<R> ingredientType, @NotNull List<List<R>> output) {
                List ingredient = JEIWrappedDisplay.this.outputs.computeIfAbsent(ingredientType, e -> new ArrayList());
                ingredient.addAll(output);
            }

            @NotNull
            public <R> List<List<R>> getInputs(@NotNull IIngredientType<R> ingredientType) {
                return JEIWrappedDisplay.this.inputs.getOrDefault(ingredientType, Collections.emptyList());
            }

            @NotNull
            public <R> List<List<R>> getOutputs(@NotNull IIngredientType<R> ingredientType) {
                return JEIWrappedDisplay.this.outputs.getOrDefault(ingredientType, Collections.emptyList());
            }
        };
        this.setupIngredients();
        this.compileIngredients();
    }

    private void compileIngredients() {
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : this.inputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                this.compiledInput.add(JEIPluginDetector.wrapList(entry.getKey(), slot));
            }
        }
        for (Map.Entry<IIngredientType<?>, List<List<?>>> entry : this.outputs.entrySet()) {
            for (List<?> slot : entry.getValue()) {
                this.compiledOutputs.add(JEIPluginDetector.wrapList(entry.getKey(), slot));
            }
        }
    }

    private void setupIngredients() {
        this.backingCategory.getBackingCategory().setIngredients(this.backingRecipe, this.ingredients);
    }

    public IIngredients getIngredients() {
        return this.ingredients;
    }

    public JEIWrappedCategory<T> getBackingCategory() {
        return this.backingCategory;
    }

    public T getBackingRecipe() {
        return this.backingRecipe;
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return this.backingCategory.getCategoryIdentifier();
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.compiledInput;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.compiledOutputs;
    }
}

