/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import me.shedaniel.architectury.networking.NetworkManager;
import me.shedaniel.rei.RoughlyEnoughItemsNetwork;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleMenuDisplay;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.MenuTransferException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultCategoryHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        if (!(context.getDisplay() instanceof SimpleMenuDisplay)) {
            return TransferHandler.Result.createNotApplicable();
        }
        SimpleMenuDisplay display = (SimpleMenuDisplay)context.getDisplay();
        ContainerScreen<?> containerScreen = context.getContainerScreen();
        if (containerScreen == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        Container menu = context.getMenu();
        MenuInfo<Container, Display> menuInfo = MenuInfoRegistry.getInstance().get(display.getCategoryIdentifier(), menu.getClass());
        if (menuInfo == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        MenuInfoContext<Container, PlayerEntity, Display> menuInfoContext = DefaultCategoryHandler.ofContext(menu, menuInfo, display);
        try {
            menuInfo.validate(menuInfoContext);
        }
        catch (MenuTransferException e) {
            return TransferHandler.Result.createFailed(e.getError());
        }
        List<List<ItemStack>> input = menuInfo.getInputs(menuInfoContext);
        IntList intList = this.hasItems(menu, menuInfo, display, input);
        if (!intList.isEmpty()) {
            return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.not.enough.materials"), intList);
        }
        if (!ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.not.on.server"));
        }
        if (!context.isActuallyCrafting()) {
            return TransferHandler.Result.createSuccessful();
        }
        context.getMinecraft().func_147108_a(containerScreen);
        if (containerScreen instanceof IRecipeShownListener) {
            ((IRecipeShownListener)containerScreen).func_194310_f().field_191915_z.func_192682_a();
        }
        PacketBuffer buf = new PacketBuffer(Unpooled.buffer());
        buf.func_192572_a(display.getCategoryIdentifier().getIdentifier());
        buf.writeBoolean(Screen.func_231173_s_());
        buf.func_150786_a(menuInfo.save(menuInfoContext, display));
        NetworkManager.sendToServer((ResourceLocation)RoughlyEnoughItemsNetwork.MOVE_ITEMS_PACKET, (PacketBuffer)buf);
        return TransferHandler.Result.createSuccessful();
    }

    @Override
    public double getPriority() {
        return -10.0;
    }

    private static MenuInfoContext<Container, PlayerEntity, Display> ofContext(final Container menu, final MenuInfo<Container, Display> info, final Display display) {
        return new MenuInfoContext<Container, PlayerEntity, Display>(){

            @Override
            public Container getMenu() {
                return menu;
            }

            @Override
            public PlayerEntity getPlayerEntity() {
                return Minecraft.func_71410_x().field_71439_g;
            }

            @Override
            public MenuInfo<Container, Display> getContainerInfo() {
                return info;
            }

            @Override
            public CategoryIdentifier<Display> getCategoryIdentifier() {
                return display.getCategoryIdentifier();
            }

            @Override
            public Display getDisplay() {
                return display;
            }
        };
    }

    public IntList hasItems(Container menu, MenuInfo<Container, Display> info, Display display, List<List<ItemStack>> inputs) {
        RecipeFinder recipeFinder = new RecipeFinder();
        info.getRecipeFinderPopulator().populate(DefaultCategoryHandler.ofContext(menu, info, display), recipeFinder);
        IntArrayList intList = new IntArrayList();
        for (int i = 0; i < inputs.size(); ++i) {
            List<ItemStack> possibleStacks = inputs.get(i);
            boolean done = possibleStacks.isEmpty();
            for (ItemStack possibleStack : possibleStacks) {
                int invRequiredCount;
                if (done) continue;
                int key = RecipeFinder.getItemId(possibleStack);
                for (invRequiredCount = possibleStack.func_190916_E(); invRequiredCount > 0 && recipeFinder.contains(key); --invRequiredCount) {
                    recipeFinder.take(key, 1);
                }
                if (invRequiredCount > 0) continue;
                done = true;
                break;
            }
            if (done) continue;
            intList.add(i);
        }
        return intList;
    }
}

