/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.autocrafting;

import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandler;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleMenuDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.client.gui.recipebook.IRecipeShownListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.RecipeBookContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultRecipeBookHandler
implements TransferHandler {
    @Override
    public TransferHandler.Result handle(TransferHandler.Context context) {
        DefaultCookingDisplay defaultDisplay;
        if (context.getDisplay() instanceof SimpleMenuDisplay && ClientHelper.getInstance().canUseMovePackets()) {
            return TransferHandler.Result.createNotApplicable();
        }
        Display display = context.getDisplay();
        if (!(context.getMenu() instanceof RecipeBookContainer)) {
            return TransferHandler.Result.createNotApplicable();
        }
        RecipeBookContainer container = (RecipeBookContainer)context.getMenu();
        if (container == null) {
            return TransferHandler.Result.createNotApplicable();
        }
        if (display instanceof DefaultCraftingDisplay) {
            DefaultCraftingDisplay craftingDisplay = (DefaultCraftingDisplay)display;
            if (craftingDisplay.getOptionalRecipe().isPresent()) {
                int h = -1;
                int w = -1;
                if (container instanceof WorkbenchContainer) {
                    h = 3;
                    w = 3;
                } else if (container instanceof PlayerContainer) {
                    h = 2;
                    w = 2;
                }
                if (h == -1 || w == -1) {
                    return TransferHandler.Result.createNotApplicable();
                }
                IRecipe<?> recipe = craftingDisplay.getOptionalRecipe().get();
                if (craftingDisplay.getHeight() > h || craftingDisplay.getWidth() > w) {
                    return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.transfer.too_small", new Object[]{h, w}));
                }
                if (!context.getMinecraft().field_71439_g.func_199507_B().func_193830_f(recipe)) {
                    return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.recipe.not.unlocked"));
                }
                if (!context.isActuallyCrafting()) {
                    return TransferHandler.Result.createSuccessful();
                }
                context.getMinecraft().func_147108_a(context.getContainerScreen());
                if (context.getContainerScreen() instanceof IRecipeShownListener) {
                    ((IRecipeShownListener)context.getContainerScreen()).func_194310_f().field_191915_z.func_192682_a();
                }
                context.getMinecraft().field_71442_b.func_203413_a(container.field_75152_c, recipe, Screen.func_231173_s_());
                return TransferHandler.Result.createSuccessful();
            }
        } else if (display instanceof DefaultCookingDisplay && (defaultDisplay = (DefaultCookingDisplay)display).getOptionalRecipe().isPresent()) {
            IRecipe<?> recipe = defaultDisplay.getOptionalRecipe().get();
            if (!context.getMinecraft().field_71439_g.func_199507_B().func_193830_f(recipe)) {
                return TransferHandler.Result.createFailed((ITextComponent)new TranslationTextComponent("error.rei.recipe.not.unlocked"));
            }
            if (!context.isActuallyCrafting()) {
                return TransferHandler.Result.createSuccessful();
            }
            context.getMinecraft().func_147108_a(context.getContainerScreen());
            if (context.getContainerScreen() instanceof IRecipeShownListener) {
                ((IRecipeShownListener)context.getContainerScreen()).func_194310_f().field_191915_z.func_192682_a();
            }
            context.getMinecraft().field_71442_b.func_203413_a(container.field_75152_c, recipe, Screen.func_231173_s_());
            return TransferHandler.Result.createSuccessful();
        }
        return TransferHandler.Result.createNotApplicable();
    }

    @Override
    public double getPriority() {
        return -20.0;
    }
}

