/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Stream;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.RoughlyEnoughItemsCore;
import me.shedaniel.rei.api.client.ClientHelper;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackProviderWidget;
import me.shedaniel.rei.api.client.gui.drag.DraggableStackVisitorWidget;
import me.shedaniel.rei.api.client.gui.widgets.Panel;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.client.registry.screen.DisplayBoundsProvider;
import me.shedaniel.rei.api.client.registry.screen.ExclusionZones;
import me.shedaniel.rei.api.client.registry.screen.ScreenRegistry;
import me.shedaniel.rei.api.client.registry.transfer.TransferHandlerRegistry;
import me.shedaniel.rei.api.client.util.ClientEntryStacks;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryTypeRegistry;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.ClientHelperImpl;
import me.shedaniel.rei.impl.client.gui.ContainerScreenOverlay;
import me.shedaniel.rei.impl.client.gui.screen.AbstractDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.screen.DefaultDisplayViewingScreen;
import me.shedaniel.rei.impl.client.gui.widget.FavoritesListWidget;
import me.shedaniel.rei.plugin.autocrafting.DefaultCategoryHandler;
import me.shedaniel.rei.plugin.client.entry.FluidEntryDefinition;
import me.shedaniel.rei.plugin.client.entry.ItemEntryDefinition;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
@ApiStatus.Internal
public class DefaultClientRuntimePlugin
implements REIClientPlugin {
    public static final ResourceLocation PLUGIN = new ResourceLocation("roughlyenoughitems", "default_runtime_plugin");

    @Override
    public void registerEntryTypes(EntryTypeRegistry registry) {
        registry.register(VanillaEntryTypes.ITEM, new ItemEntryDefinition());
        registry.register(VanillaEntryTypes.FLUID, new FluidEntryDefinition());
        registry.registerBridge(VanillaEntryTypes.ITEM, VanillaEntryTypes.FLUID, input -> {
            Optional<Stream<EntryStack<FluidStack>>> stream = FluidSupportProvider.getInstance().itemToFluids(input);
            if (!stream.isPresent()) {
                return ActionResult.func_226250_c_(Stream.empty());
            }
            return ActionResult.func_226248_a_(stream.get());
        });
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        if (((Boolean)ClientHelperImpl.getInstance().isAprilFools.func_179281_c()).booleanValue()) {
            registry.addEntry(ClientEntryStacks.of(new AbstractRenderer(){
                private ResourceLocation id = new ResourceLocation("roughlyenoughitems", "textures/gui/kirb.png");

                @Override
                public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                    Minecraft.func_71410_x().func_110434_K().func_110577_a(this.id);
                    1.func_238461_a_((Matrix4f)matrices.func_227866_c_().func_227870_a_(), (int)bounds.x, (int)bounds.getMaxX(), (int)bounds.y, (int)bounds.getMaxY(), (int)this.func_230927_p_(), (float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                }

                @Override
                @Nullable
                public Tooltip getTooltip(Point point) {
                    return Tooltip.create(new ITextComponent[]{new StringTextComponent("Kirby"), ClientHelper.getInstance().getFormattedModFromModId("Dream Land")});
                }
            }));
        }
    }

    @Override
    public void registerScreens(ScreenRegistry registry) {
        ExclusionZones zones = registry.exclusionZones();
        zones.register(DefaultDisplayViewingScreen.class, screen -> {
            Panel widget = screen.getWorkingStationsBaseWidget();
            if (widget == null) {
                return Collections.emptyList();
            }
            return Collections.singletonList(widget.getBounds().clone());
        });
        zones.register(Screen.class, screen -> {
            FavoritesListWidget widget = ContainerScreenOverlay.getFavoritesListWidget();
            if (widget != null && widget.favoritePanelButton.isVisible()) {
                return Collections.singletonList(widget.favoritePanelButton.bounds);
            }
            return Collections.emptyList();
        });
        registry.registerDecider(new DisplayBoundsProvider<AbstractDisplayViewingScreen>(){

            @Override
            public Rectangle getScreenBounds(AbstractDisplayViewingScreen screen) {
                return screen.getBounds();
            }

            @Override
            public <R extends Screen> boolean isHandingScreen(Class<R> screen) {
                return AbstractDisplayViewingScreen.class.isAssignableFrom(screen);
            }

            @Override
            public ActionResultType shouldScreenBeOverlaid(Class<?> screen) {
                return ActionResultType.SUCCESS;
            }
        });
        registry.registerDraggableStackProvider(DraggableStackProviderWidget.from(context -> {
            if (RoughlyEnoughItemsCore.shouldReturn(context.getScreen()) || !REIHelper.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIHelper.getInstance().getOverlay().get().func_231039_at__(), DraggableStackProviderWidget.class::isInstance);
        }));
        registry.registerDraggableStackVisitor(DraggableStackVisitorWidget.from(context -> {
            if (RoughlyEnoughItemsCore.shouldReturn(context.getScreen()) || !REIHelper.getInstance().isOverlayVisible()) {
                return Collections.emptyList();
            }
            return Widgets.walk(REIHelper.getInstance().getOverlay().get().func_231039_at__(), DraggableStackVisitorWidget.class::isInstance);
        }));
    }

    @Override
    public void registerFavorites(FavoriteEntryType.Registry registry) {
        registry.register(EntryStackFavoriteType.INSTANCE.id, EntryStackFavoriteType.INSTANCE);
    }

    @Override
    public void registerTransferHandlers(TransferHandlerRegistry registry) {
        registry.register(new DefaultCategoryHandler());
    }

    private static class EntryStackFavoriteEntry
    extends FavoriteEntry {
        private static final Function<EntryStack<?>, String> CANCEL_FLUID_AMOUNT = s -> null;
        private final EntryStack<?> stack;
        private final long hashIgnoreAmount;

        public EntryStackFavoriteEntry(EntryStack<?> stack) {
            this.stack = stack.normalize();
            this.hashIgnoreAmount = EntryStacks.hashExact(this.stack);
        }

        @Override
        public boolean isInvalid() {
            return this.stack.isEmpty();
        }

        @Override
        public Renderer getRenderer(boolean showcase) {
            return this.stack;
        }

        @Override
        public boolean doAction(int button) {
            if (!ClientHelper.getInstance().isCheating()) {
                return false;
            }
            EntryStack<Object> entry = this.stack.copy();
            if (!entry.isEmpty()) {
                Item bucketItem;
                if (entry.getValueType() == FluidStack.class && (bucketItem = ((FluidStack)entry.getValue()).getFluid().func_204524_b()) != null) {
                    entry = EntryStacks.of((IItemProvider)bucketItem);
                }
                if (entry.getType() == VanillaEntryTypes.ITEM) {
                    ((ItemStack)entry.cast().getValue()).func_190920_e(button != 1 && !Screen.func_231173_s_() ? 1 : ((ItemStack)entry.getValue()).func_77976_d());
                }
                return ClientHelper.getInstance().tryCheatingEntry(entry);
            }
            return false;
        }

        @Override
        public long hashIgnoreAmount() {
            return this.hashIgnoreAmount;
        }

        @Override
        public FavoriteEntry copy() {
            return new EntryStackFavoriteEntry(this.stack.normalize());
        }

        @Override
        public ResourceLocation getType() {
            return EntryStackFavoriteType.INSTANCE.id;
        }

        @Override
        public boolean isSame(FavoriteEntry other) {
            if (!(other instanceof EntryStackFavoriteEntry)) {
                return false;
            }
            EntryStackFavoriteEntry that = (EntryStackFavoriteEntry)other;
            return EntryStacks.equalsExact(this.stack, that.stack);
        }
    }

    private static enum EntryStackFavoriteType implements FavoriteEntryType<EntryStackFavoriteEntry>
    {
        INSTANCE(FavoriteEntryType.ENTRY_STACK);

        private final String key = "data";
        private ResourceLocation id;

        private EntryStackFavoriteType(ResourceLocation id) {
            this.id = id;
        }

        @Override
        public EntryStackFavoriteEntry read(CompoundNBT object) {
            return new EntryStackFavoriteEntry(EntryStack.read(object.func_74775_l("data")));
        }

        @Override
        public EntryStackFavoriteEntry fromArgs(Object ... args) {
            return new EntryStackFavoriteEntry((EntryStack)args[0]);
        }

        @Override
        public CompoundNBT save(EntryStackFavoriteEntry entry, CompoundNBT tag) {
            tag.func_218657_a("data", (INBT)entry.stack.save());
            return tag;
        }
    }
}

