/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.categories;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.DisplayRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class DefaultInformationCategory
implements DisplayCategory<DefaultInformationDisplay> {
    protected static void innerBlit(Matrix4f matrix4f, int xStart, int xEnd, int yStart, int yEnd, int z, float uStart, float uEnd, float vStart, float vEnd) {
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_227888_a_(matrix4f, (float)xStart, (float)yEnd, (float)z).func_225583_a_(uStart, vEnd).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)xEnd, (float)yEnd, (float)z).func_225583_a_(uEnd, vEnd).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)xEnd, (float)yStart, (float)z).func_225583_a_(uEnd, vStart).func_181675_d();
        bufferBuilder.func_227888_a_(matrix4f, (float)xStart, (float)yStart, (float)z).func_225583_a_(uStart, vStart).func_181675_d();
        bufferBuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
    }

    @Override
    public CategoryIdentifier<? extends DefaultInformationDisplay> getCategoryIdentifier() {
        return BuiltinPlugin.INFO;
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("category.rei.information");
    }

    @Override
    public DisplayRenderer getDisplayRenderer(DefaultInformationDisplay display) {
        final IReorderingProcessor name = display.getName().func_241878_f();
        return new DisplayRenderer(){

            @Override
            public int getHeight() {
                Minecraft.func_71410_x().field_71466_p.getClass();
                return 10 + 9;
            }

            @Override
            public void render(MatrixStack matrices, Rectangle rectangle, int mouseX, int mouseY, float delta) {
                Minecraft.func_71410_x().field_71466_p.func_238422_b_(matrices, name, (float)(rectangle.x + 5), (float)(rectangle.y + 6), -1);
            }
        };
    }

    @Override
    public Renderer getIcon() {
        return new AbstractRenderer(){

            @Override
            public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(REIHelper.getInstance().getDefaultDisplayTexture());
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)-1.2f, -1.0, 0.0);
                Matrix4f matrix = matrices.func_227866_c_().func_227870_a_();
                DefaultInformationCategory.innerBlit(matrix, bounds.getCenterX() - 8, bounds.getCenterX() + 8, bounds.getCenterY() - 8, bounds.getCenterY() + 8, 0, 0.453125f, 0.515625f, 0.0f, 0.0625f);
                matrices.func_227865_b_();
            }
        };
    }

    @Override
    public List<Widget> setupDisplay(DefaultInformationDisplay display, Rectangle bounds) {
        ArrayList widgets = Lists.newArrayList();
        widgets.add(Widgets.createSlot(new Point(bounds.getCenterX() - 8, bounds.y + 15 - 9)).entries(display.getEntryStacks()));
        Rectangle rectangle = new Rectangle(bounds.getCenterX() - bounds.width / 2, bounds.y + 35 - 9, bounds.width, bounds.height - 40 + 9);
        widgets.add(Widgets.createSlotBase(rectangle));
        widgets.add(new ScrollableTextWidget(rectangle, display.getTexts()));
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 140;
    }

    @Override
    public int getFixedDisplaysPerPage() {
        return 1;
    }

    private static class ScrollableTextWidget
    extends WidgetWithBounds {
        private Rectangle bounds;
        private List<IReorderingProcessor> texts;
        private final ScrollingContainer scrolling = new ScrollingContainer(){

            public Rectangle getBounds() {
                Rectangle bounds = this.getBounds();
                return new Rectangle(bounds.x + 1, bounds.y + 1, bounds.width - 2, bounds.height - 2);
            }

            public int getMaxScrollHeight() {
                int i = 2;
                for (IReorderingProcessor entry : texts) {
                    int n;
                    if (entry == null) {
                        n = 4;
                    } else {
                        font.getClass();
                        n = 9;
                    }
                    i += n;
                }
                return i;
            }
        };

        public ScrollableTextWidget(Rectangle bounds, List<ITextComponent> texts) {
            this.bounds = Objects.requireNonNull(bounds);
            this.texts = Lists.newArrayList();
            for (ITextProperties iTextProperties : texts) {
                if (!this.texts.isEmpty()) {
                    this.texts.add(null);
                }
                this.texts.addAll(Minecraft.func_71410_x().field_71466_p.func_238425_b_(iTextProperties, bounds.width - 11));
            }
        }

        public boolean func_231043_a_(double double_1, double double_2, double double_3) {
            if (this.containsMouse(double_1, double_2)) {
                this.scrolling.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            if (this.scrolling.updateDraggingState(mouseX, mouseY, button)) {
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }

        public boolean func_231045_a_(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
            if (this.scrolling.mouseDragged(mouseX, mouseY, button, deltaX, deltaY)) {
                return true;
            }
            return super.func_231045_a_(mouseX, mouseY, button, deltaX, deltaY);
        }

        @Override
        public Rectangle getBounds() {
            return this.bounds;
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            this.scrolling.updatePosition(delta);
            Rectangle innerBounds = this.scrolling.getScissorBounds();
            ScissorsHandler.INSTANCE.scissor(innerBounds);
            int currentY = (int)(-this.scrolling.scrollAmount) + innerBounds.y;
            for (IReorderingProcessor text : this.texts) {
                int n;
                if (text != null) {
                    this.font.getClass();
                    if (currentY + 9 >= innerBounds.y && currentY <= innerBounds.getMaxY()) {
                        this.font.func_238422_b_(matrices, text, (float)(innerBounds.x + 2), (float)(currentY + 2), REIHelper.getInstance().isDarkThemeEnabled() ? -4473925 : -16185079);
                    }
                }
                if (text == null) {
                    n = 4;
                } else {
                    this.font.getClass();
                    n = 9;
                }
                currentY += n;
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            ScissorsHandler.INSTANCE.scissor(this.scrolling.getBounds());
            this.scrolling.renderScrollBar(-16777216, 1.0f, REIHelper.getInstance().isDarkThemeEnabled() ? 0.8f : 1.0f);
            ScissorsHandler.INSTANCE.removeLastScissor();
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }
    }
}

