/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.shedaniel.architectury.fluid.FluidStack;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.architectury.platform.Platform;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.architectury.utils.Fraction;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.util.SpriteRenderer;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.I18n;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class FluidEntryDefinition
implements EntryDefinition<FluidStack>,
EntrySerializer<FluidStack> {
    private static final String FLUID_AMOUNT = Platform.isForge() ? "tooltip.rei.fluid_amount.forge" : "tooltip.rei.fluid_amount";
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<FluidStack> renderer;

    public FluidEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            this.renderer = new FluidEntryRenderer();
        });
    }

    @Override
    public Class<FluidStack> getValueType() {
        return FluidStack.class;
    }

    @Override
    public EntryType<FluidStack> getType() {
        return VanillaEntryTypes.FLUID;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<FluidStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<FluidStack> entry, FluidStack value) {
        return Registry.field_212619_h.func_177774_c((Object)value.getFluid());
    }

    @Override
    public boolean isEmpty(EntryStack<FluidStack> entry, FluidStack value) {
        return value.isEmpty();
    }

    @Override
    public FluidStack copy(EntryStack<FluidStack> entry, FluidStack value) {
        return value.copy();
    }

    @Override
    public FluidStack normalize(EntryStack<FluidStack> entry, FluidStack value) {
        Fluid fluid = value.getFluid();
        if (fluid instanceof FlowingFluid) {
            fluid = ((FlowingFluid)fluid).func_210198_f();
        }
        FluidStack copy = FluidStack.create((Fluid)fluid, (Fraction)value.getAmount(), (CompoundNBT)value.getTag());
        copy.setAmount(FluidStack.bucketAmount());
        return copy;
    }

    @Override
    public long hash(EntryStack<FluidStack> entry, FluidStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + value.getFluid().hashCode();
        code = 31 * code + (context.isFuzzy() || !value.hasTag() ? 0 : value.getTag().hashCode());
        return code;
    }

    @Override
    public boolean equals(FluidStack o1, FluidStack o2, ComparisonContext context) {
        if (o1.getFluid() != o2.getFluid()) {
            return false;
        }
        return context.isFuzzy() || this.isTagEqual(o1, o2);
    }

    private boolean isTagEqual(FluidStack o1, FluidStack o2) {
        CompoundNBT tag1 = o1.getTag();
        CompoundNBT tag2 = o2.getTag();
        return Objects.equals(tag1, tag2);
    }

    @Override
    @Nullable
    public EntrySerializer<FluidStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public CompoundNBT save(EntryStack<FluidStack> entry, FluidStack value) {
        return value.write(new CompoundNBT());
    }

    @Override
    public FluidStack read(CompoundNBT tag) {
        return FluidStack.read((CompoundNBT)tag);
    }

    @Override
    public ITextComponent asFormattedText(EntryStack<FluidStack> entry, FluidStack value) {
        return value.getName();
    }

    @Override
    public Collection<ResourceLocation> getTagsFor(ITagCollectionSupplier tagContainer, EntryStack<FluidStack> entry, FluidStack value) {
        ITagCollection collection = tagContainer.func_241837_c();
        return collection == null ? Collections.emptyList() : collection.func_199913_a((Object)value.getFluid());
    }

    public static EntryStack<FluidStack> simplifyAmount(EntryStack<FluidStack> stack) {
        stack.getValue().setAmount(stack.getValue().getAmount().simplify());
        return stack;
    }

    public static class FluidEntryRenderer
    extends AbstractEntryRenderer<FluidStack> {
        @Override
        public void render(EntryStack<FluidStack> entry, MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
            FluidStack stack = entry.getValue();
            if (stack.isEmpty()) {
                return;
            }
            TextureAtlasSprite sprite = FluidStackHooks.getStillTexture((FluidStack)stack);
            if (sprite == null) {
                return;
            }
            int color = FluidStackHooks.getColor((FluidStack)stack);
            IRenderTypeBuffer.Impl immediate = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            SpriteRenderer.beginPass().setup((IRenderTypeBuffer)immediate, RenderType.func_228639_c_()).sprite(sprite).color(color).light(0xF000F0).overlay(OverlayTexture.field_229196_a_).alpha(255).normal(matrices.func_227866_c_().func_227872_b_(), 0.0f, 0.0f, 0.0f).position(matrices.func_227866_c_().func_227870_a_(), bounds.x, (float)bounds.getMaxY() - (float)bounds.height * MathHelper.func_76131_a((float)entry.get(EntryStack.Settings.FLUID_RENDER_RATIO).floatValue(), (float)0.0f, (float)1.0f), bounds.getMaxX(), bounds.getMaxY(), entry.getZ()).next(PlayerContainer.field_226615_c_);
            immediate.func_228461_a_();
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<FluidStack> entry, Point mouse) {
            String amountTooltip;
            if (entry.isEmpty()) {
                return null;
            }
            ArrayList toolTip = Lists.newArrayList((Object[])new ITextComponent[]{entry.asFormattedText()});
            Fraction amount = entry.getValue().getAmount();
            if (!amount.isLessThan(Fraction.zero()) && (amountTooltip = I18n.func_135052_a((String)FLUID_AMOUNT, (Object[])new Object[]{FluidEntryDefinition.simplifyAmount(entry).getValue().getAmount()})) != null) {
                toolTip.addAll(Stream.of(amountTooltip.split("\n")).map(StringTextComponent::new).collect(Collectors.toList()));
            }
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                ResourceLocation fluidId = Registry.field_212619_h.func_177774_c((Object)entry.getValue().getFluid());
                toolTip.add(new StringTextComponent(fluidId.toString()).func_240699_a_(TextFormatting.DARK_GRAY));
            }
            return Tooltip.create(toolTip);
        }
    }
}

