/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.entry;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import it.unimi.dsi.fastutil.objects.ReferenceSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.shedaniel.architectury.utils.Env;
import me.shedaniel.architectury.utils.EnvExecutor;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.entry.renderer.AbstractEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.BatchedEntryRenderer;
import me.shedaniel.rei.api.client.entry.renderer.EntryRenderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.entry.EntrySerializer;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ComparisonContext;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.entry.type.EntryDefinition;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.util.ImmutableTextComponent;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ITagCollectionSupplier;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class ItemEntryDefinition
implements EntryDefinition<ItemStack>,
EntrySerializer<ItemStack> {
    @OnlyIn(value=Dist.CLIENT)
    private EntryRenderer<ItemStack> renderer;
    private static final ReferenceSet<Item> SEARCH_BLACKLISTED = new ReferenceOpenHashSet();

    public ItemEntryDefinition() {
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> () -> {
            this.renderer = new ItemEntryRenderer();
        });
    }

    @Override
    public Class<ItemStack> getValueType() {
        return ItemStack.class;
    }

    @Override
    public EntryType<ItemStack> getType() {
        return VanillaEntryTypes.ITEM;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public EntryRenderer<ItemStack> getRenderer() {
        return this.renderer;
    }

    @Override
    @Nullable
    public ResourceLocation getIdentifier(EntryStack<ItemStack> entry, ItemStack value) {
        return Registry.field_212630_s.func_177774_c((Object)value.func_77973_b());
    }

    @Override
    public boolean isEmpty(EntryStack<ItemStack> entry, ItemStack value) {
        return value.func_190926_b();
    }

    @Override
    public ItemStack copy(EntryStack<ItemStack> entry, ItemStack value) {
        return value.func_77946_l();
    }

    @Override
    public ItemStack normalize(EntryStack<ItemStack> entry, ItemStack value) {
        ItemStack copy = value.func_77946_l();
        copy.func_190920_e(1);
        return copy;
    }

    @Override
    public long hash(EntryStack<ItemStack> entry, ItemStack value, ComparisonContext context) {
        int code = 1;
        code = 31 * code + System.identityHashCode(value.func_77973_b());
        code = 31 * code + Long.hashCode(ItemComparatorRegistry.getInstance().hashOf(context, value));
        return code;
    }

    @Override
    public boolean equals(ItemStack o1, ItemStack o2, ComparisonContext context) {
        if (o1.func_77973_b() != o2.func_77973_b()) {
            return false;
        }
        return ItemComparatorRegistry.getInstance().hashOf(context, o1) == ItemComparatorRegistry.getInstance().hashOf(context, o2);
    }

    @Override
    @Nullable
    public EntrySerializer<ItemStack> getSerializer() {
        return this;
    }

    @Override
    public boolean supportSaving() {
        return true;
    }

    @Override
    public boolean supportReading() {
        return true;
    }

    @Override
    public CompoundNBT save(EntryStack<ItemStack> entry, ItemStack value) {
        return value.func_77955_b(new CompoundNBT());
    }

    @Override
    public ItemStack read(CompoundNBT tag) {
        return ItemStack.func_199557_a((CompoundNBT)tag);
    }

    @Override
    public ITextComponent asFormattedText(EntryStack<ItemStack> entry, ItemStack value) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.func_77973_b())) {
            try {
                return value.func_200301_q();
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.func_77973_b());
            }
        }
        try {
            return new ImmutableTextComponent(I18n.func_135052_a((String)("item." + Registry.field_212630_s.func_177774_c((Object)value.func_77973_b()).toString().replace(":", ".")), (Object[])new Object[0]));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return new ImmutableTextComponent("ERROR");
        }
    }

    @Override
    public Collection<ResourceLocation> getTagsFor(ITagCollectionSupplier tagContainer, EntryStack<ItemStack> entry, ItemStack value) {
        ITagCollection collection = tagContainer.func_241836_b();
        return collection == null ? Collections.emptyList() : collection.func_199913_a((Object)value.func_77973_b());
    }

    private List<ITextComponent> tryGetItemStackToolTip(EntryStack<ItemStack> entry, ItemStack value, boolean careAboutAdvanced) {
        if (!SEARCH_BLACKLISTED.contains((Object)value.func_77973_b())) {
            try {
                return value.func_82840_a((PlayerEntity)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)(careAboutAdvanced && Minecraft.func_71410_x().field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL));
            }
            catch (Throwable e) {
                e.printStackTrace();
                SEARCH_BLACKLISTED.add((Object)value.func_77973_b());
            }
        }
        return Lists.newArrayList((Object[])new ITextComponent[]{this.asFormattedText(entry, value)});
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ItemEntryRenderer
    extends AbstractEntryRenderer<ItemStack>
    implements BatchedEntryRenderer<ItemStack, IBakedModel> {
        public static final int ITEM_LIGHT = 0xF000F0;

        @Override
        public IBakedModel getExtraData(EntryStack<ItemStack> entry) {
            return Minecraft.func_71410_x().func_175599_af().func_184393_a(entry.getValue(), null, null);
        }

        @Override
        public int getBatchIdentifier(EntryStack<ItemStack> entry, Rectangle bounds, IBakedModel model) {
            return 1738923 + (model.func_230044_c_() ? 1 : 0);
        }

        @Override
        public void startBatch(EntryStack<ItemStack> entry, IBakedModel model, MatrixStack matrices, float delta) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
            Minecraft.func_71410_x().func_110434_K().func_229267_b_(AtlasTexture.field_110575_b).func_174937_a(false, false);
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            boolean sideLit = model.func_230044_c_();
            if (!sideLit) {
                RenderHelper.func_227783_c_();
            }
        }

        @Override
        public void renderBase(EntryStack<ItemStack> entry, IBakedModel model, MatrixStack matrices, IRenderTypeBuffer.Impl immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                ItemStack stack = entry.getValue();
                matrices.func_227860_a_();
                matrices.func_227861_a_((double)bounds.getCenterX(), (double)bounds.getCenterY(), (double)(100.0f + (float)entry.getZ()));
                matrices.func_227862_a_((float)bounds.getWidth(), (float)(bounds.getWidth() + bounds.getHeight()) / -2.0f, (float)bounds.getHeight());
                Minecraft.func_71410_x().func_175599_af().func_229111_a_(stack, ItemCameraTransforms.TransformType.GUI, false, matrices, (IRenderTypeBuffer)immediate, 0xF000F0, OverlayTexture.field_229196_a_, model);
                matrices.func_227865_b_();
            }
        }

        @Override
        public void renderOverlay(EntryStack<ItemStack> entry, IBakedModel model, MatrixStack matrices, IRenderTypeBuffer.Impl immediate, Rectangle bounds, int mouseX, int mouseY, float delta) {
            if (!entry.isEmpty()) {
                Minecraft.func_71410_x().func_175599_af().field_77023_b = entry.getZ();
                Minecraft.func_71410_x().func_175599_af().func_180453_a(Minecraft.func_71410_x().field_71466_p, entry.getValue(), bounds.x, bounds.y, null);
                Minecraft.func_71410_x().func_175599_af().field_77023_b = 0.0f;
            }
        }

        @Override
        public void endBatch(EntryStack<ItemStack> entry, IBakedModel model, MatrixStack matrices, float delta) {
            RenderSystem.enableDepthTest();
            RenderSystem.disableAlphaTest();
            RenderSystem.disableRescaleNormal();
            boolean sideLit = model.func_230044_c_();
            if (!sideLit) {
                RenderHelper.func_227784_d_();
            }
            RenderSystem.popMatrix();
        }

        @Override
        @Nullable
        public Tooltip getTooltip(EntryStack<ItemStack> entry, Point mouse) {
            if (entry.isEmpty()) {
                return null;
            }
            return Tooltip.create(ItemEntryDefinition.this.tryGetItemStackToolTip(entry, entry.getValue(), true));
        }
    }
}

