/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.client.favorites;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.REIHelper;
import me.shedaniel.rei.api.client.config.ConfigObject;
import me.shedaniel.rei.api.client.favorites.CompoundFavoriteRenderer;
import me.shedaniel.rei.api.client.favorites.FavoriteEntry;
import me.shedaniel.rei.api.client.favorites.FavoriteEntryType;
import me.shedaniel.rei.api.client.favorites.FavoriteMenuEntry;
import me.shedaniel.rei.api.client.gui.AbstractRenderer;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SimpleSound;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import org.jetbrains.annotations.Nullable;

public class GameModeFavoriteEntry
extends FavoriteEntry {
    public static final ResourceLocation ID = new ResourceLocation("roughlyenoughitems", "gamemode");
    public static final String TRANSLATION_KEY = "favorite.section.gamemode";
    public static final String KEY = "mode";
    @Nullable
    private final GameType gameMode;

    public GameModeFavoriteEntry(@Nullable GameType gameMode) {
        this.gameMode = gameMode;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }

    @Override
    public Renderer getRenderer(boolean showcase) {
        if (this.gameMode == null) {
            List renderers = IntStream.range(0, 4).mapToObj(GameModeFavoriteEntry::getRenderer).collect(Collectors.toList());
            return new CompoundFavoriteRenderer(showcase, renderers, () -> Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77148_a()){

                @Override
                @Nullable
                public Tooltip getTooltip(Point mouse) {
                    return Tooltip.create(mouse, new ITextComponent[]{new TranslationTextComponent("text.rei.gamemode_button.tooltip.dropdown")});
                }

                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (o == null || this.getClass() != o.getClass()) {
                        return false;
                    }
                    return this.hashCode() == o.hashCode();
                }

                public int hashCode() {
                    return Objects.hash(this.getClass(), this.showcase);
                }
            };
        }
        return GameModeFavoriteEntry.getRenderer(this.gameMode.func_77148_a());
    }

    private static Renderer getRenderer(int id) {
        final GameType type = GameType.func_77146_a((int)id);
        return new AbstractRenderer(){

            @Override
            public void render(MatrixStack matrices, Rectangle bounds, int mouseX, int mouseY, float delta) {
                int color;
                int n = color = bounds.contains(mouseX, mouseY) ? -1118482 : -5592406;
                if (bounds.width > 4 && bounds.height > 4) {
                    matrices.func_227860_a_();
                    matrices.func_227861_a_((double)bounds.getCenterX(), (double)bounds.getCenterY(), 0.0);
                    matrices.func_227862_a_((float)bounds.getWidth() / 18.0f, (float)bounds.getHeight() / 18.0f, 1.0f);
                    this.renderGameModeText(matrices, type, 0, 0, color);
                    matrices.func_227865_b_();
                }
            }

            private void renderGameModeText(MatrixStack matrices, GameType type2, int centerX, int centerY, int color) {
                TranslationTextComponent s = new TranslationTextComponent("text.rei.short_gamemode." + type2.func_77149_b());
                FontRenderer font = Minecraft.func_71410_x().field_71466_p;
                font.func_243248_b(matrices, (ITextComponent)s, (float)centerX - (float)font.func_238414_a_((ITextProperties)s) / 2.0f + 0.5f, (float)centerY - 3.5f, color);
            }

            @Override
            @Nullable
            public Tooltip getTooltip(Point mouse) {
                return Tooltip.create(mouse, new ITextComponent[]{new TranslationTextComponent("text.rei.gamemode_button.tooltip.entry", new Object[]{type.func_196220_c().getString()})});
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                return this.hashCode() == o.hashCode();
            }

            public int hashCode() {
                return Objects.hash(this.getClass(), false, type);
            }
        };
    }

    @Override
    public boolean doAction(int button) {
        if (button == 0) {
            GameType mode = this.gameMode;
            if (mode == null) {
                mode = GameType.func_77146_a((int)(Minecraft.func_71410_x().field_71442_b.func_178889_l().func_77148_a() + 1));
            }
            Minecraft.func_71410_x().field_71439_g.func_71165_d(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", mode.name().toLowerCase(Locale.ROOT)));
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return false;
    }

    @Override
    public Optional<Supplier<Collection<FavoriteMenuEntry>>> getMenuEntries() {
        if (this.gameMode == null) {
            return Optional.of(this::_getMenuEntries);
        }
        return Optional.empty();
    }

    private Collection<FavoriteMenuEntry> _getMenuEntries() {
        return CollectionUtils.filterAndMap(Arrays.asList(GameType.values()), type -> type.func_77148_a() >= 0, GameModeMenuEntry::new);
    }

    @Override
    public long hashIgnoreAmount() {
        return this.gameMode == null ? -1L : (long)this.gameMode.ordinal();
    }

    @Override
    public FavoriteEntry copy() {
        return this;
    }

    @Override
    public ResourceLocation getType() {
        return ID;
    }

    @Override
    public boolean isSame(FavoriteEntry other) {
        if (!(other instanceof GameModeFavoriteEntry)) {
            return false;
        }
        GameModeFavoriteEntry that = (GameModeFavoriteEntry)other;
        return Objects.equals(this.gameMode, that.gameMode);
    }

    public static class GameModeMenuEntry
    extends FavoriteMenuEntry {
        public final String text;
        public final GameType gameMode;
        private int x;
        private int y;
        private int width;
        private boolean selected;
        private boolean containsMouse;
        private boolean rendering;
        private int textWidth = -69;

        public GameModeMenuEntry(GameType gameMode) {
            this.text = gameMode.func_196220_c().getString();
            this.gameMode = gameMode;
        }

        private int getTextWidth() {
            if (this.textWidth == -69) {
                this.textWidth = Math.max(0, this.font.func_78256_a(this.text));
            }
            return this.textWidth;
        }

        @Override
        public int getEntryWidth() {
            return this.getTextWidth() + 4;
        }

        @Override
        public int getEntryHeight() {
            return 12;
        }

        public List<? extends IGuiEventListener> func_231039_at__() {
            return Collections.emptyList();
        }

        @Override
        public void updateInformation(int xPos, int yPos, boolean selected, boolean containsMouse, boolean rendering, int width) {
            this.x = xPos;
            this.y = yPos;
            this.selected = selected;
            this.containsMouse = containsMouse;
            this.rendering = rendering;
            this.width = width;
        }

        public void func_230430_a_(MatrixStack matrices, int mouseX, int mouseY, float delta) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.field_71442_b.func_178889_l() == this.gameMode;
            if (this.selected && !disabled) {
                GameModeMenuEntry.func_238467_a_((MatrixStack)matrices, (int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + 12), (int)-12237499);
            }
            if (!disabled && this.selected && this.containsMouse) {
                REIHelper.getInstance().queueTooltip(Tooltip.create(new ITextComponent[]{new TranslationTextComponent("text.rei.gamemode_button.tooltip.entry", new Object[]{this.text})}));
            }
            String s = this.text;
            if (disabled) {
                s = TextFormatting.STRIKETHROUGH.toString() + s;
            }
            this.font.func_238421_b_(matrices, s, (float)(this.x + 2), (float)(this.y + 2), this.selected && !disabled ? 0xFFFFFF : 0x888888);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            boolean disabled;
            boolean bl = disabled = this.minecraft.field_71442_b.func_178889_l() == this.gameMode;
            if (!disabled && this.rendering && mouseX >= (double)this.x && mouseX <= (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY <= (double)(this.y + 12)) {
                Minecraft.func_71410_x().field_71439_g.func_71165_d(ConfigObject.getInstance().getGamemodeCommand().replaceAll("\\{gamemode}", this.gameMode.name().toLowerCase(Locale.ROOT)));
                this.minecraft.func_147118_V().func_147682_a((ISound)SimpleSound.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
                this.closeMenu();
                return true;
            }
            return super.func_231044_a_(mouseX, mouseY, button);
        }
    }

    public static enum Type implements FavoriteEntryType<GameModeFavoriteEntry>
    {
        INSTANCE;


        @Override
        public GameModeFavoriteEntry read(CompoundNBT object) {
            String stringValue = object.func_74779_i(GameModeFavoriteEntry.KEY);
            GameType type = stringValue.equals("NOT_SET") ? null : GameType.valueOf((String)stringValue);
            return new GameModeFavoriteEntry(type);
        }

        @Override
        public GameModeFavoriteEntry fromArgs(Object ... args) {
            return new GameModeFavoriteEntry((GameType)args[0]);
        }

        @Override
        public CompoundNBT save(GameModeFavoriteEntry entry, CompoundNBT tag) {
            tag.func_74778_a(GameModeFavoriteEntry.KEY, entry.gameMode == null ? "NOT_SET" : entry.gameMode.name());
            return tag;
        }
    }
}

