/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common;

import java.util.List;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Stream;
import me.shedaniel.architectury.hooks.FluidStackHooks;
import me.shedaniel.rei.api.common.display.DisplaySerializerRegistry;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparator;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.fluid.FluidSupportProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.simple.RecipeBookGridMenuInfo;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.DefaultCampfireDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultCompostingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultFuelDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultInformationDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultPathingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultSmithingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStoneCuttingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultStrippingDisplay;
import me.shedaniel.rei.plugin.common.displays.DefaultTillingDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconBaseDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconDisplay;
import me.shedaniel.rei.plugin.common.displays.beacon.DefaultBeaconPaymentDisplay;
import me.shedaniel.rei.plugin.common.displays.brewing.DefaultBrewingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultBlastingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultCookingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmeltingDisplay;
import me.shedaniel.rei.plugin.common.displays.cooking.DefaultSmokingDisplay;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.inventory.container.BlastFurnaceContainer;
import net.minecraft.inventory.container.FurnaceContainer;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.SmokerContainer;
import net.minecraft.inventory.container.WorkbenchContainer;
import net.minecraft.item.BucketItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ActionResult;

public class DefaultPlugin
implements BuiltinPlugin,
REIServerPlugin {
    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        ToLongFunction<INBT> nbtHasher = ItemComparator.nbtHasher(new String[0]);
        Function<ItemStack, ListNBT> enchantmentTag = stack -> {
            CompoundNBT tag = stack.func_77978_p();
            if (tag == null) {
                return null;
            }
            if (!tag.func_150297_b("Enchantments", 9)) {
                return null;
            }
            return tag.func_150295_c("Enchantments", 10);
        };
        registry.register((context, stack) -> nbtHasher.applyAsLong((INBT)enchantmentTag.apply(stack)), Items.field_151134_bR);
        registry.registerNbt(Items.field_151068_bn);
        registry.registerNbt(Items.field_185155_bH);
        registry.registerNbt(Items.field_185156_bI);
        registry.registerNbt(Items.field_185167_i);
    }

    @Override
    public void registerFluidSupport(FluidSupportProvider support) {
        support.register(entry -> {
            ItemStack stack = (ItemStack)entry.getValue();
            if (stack.func_77973_b() instanceof BucketItem) {
                return ActionResult.func_226248_a_(Stream.of(EntryStacks.of(((BucketItem)stack.func_77973_b()).field_77876_a, FluidStackHooks.bucketAmount())));
            }
            return ActionResult.func_226250_c_(null);
        });
    }

    @Override
    public void registerDisplaySerializer(DisplaySerializerRegistry registry) {
        registry.register(CRAFTING, DefaultCraftingDisplay.Serializer.INSTANCE);
        registry.register(SMELTING, DefaultCookingDisplay.serializer(DefaultSmeltingDisplay::new));
        registry.register(SMOKING, DefaultCookingDisplay.serializer(DefaultSmokingDisplay::new));
        registry.register(BLASTING, DefaultCookingDisplay.serializer(DefaultBlastingDisplay::new));
        registry.register(CAMPFIRE, DefaultCampfireDisplay.serializer());
        registry.register(STONE_CUTTING, DefaultStoneCuttingDisplay.serializer());
        registry.register(STRIPPING, DefaultStrippingDisplay.serializer());
        registry.register(BREWING, DefaultBrewingDisplay.serializer());
        registry.register(COMPOSTING, DefaultCompostingDisplay.serializer());
        registry.register(FUEL, DefaultFuelDisplay.serializer());
        registry.register(SMITHING, DefaultSmithingDisplay.serializer());
        registry.register(BEACON_BASE, DefaultBeaconDisplay.serializer(DefaultBeaconBaseDisplay::new));
        registry.register(BEACON_PAYMENT, DefaultBeaconDisplay.serializer(DefaultBeaconPaymentDisplay::new));
        registry.register(TILLING, DefaultTillingDisplay.serializer());
        registry.register(PATHING, DefaultPathingDisplay.serializer());
        registry.register(INFO, DefaultInformationDisplay.serializer());
    }

    @Override
    public void registerMenuInfo(MenuInfoRegistry registry) {
        registry.register(BuiltinPlugin.CRAFTING, WorkbenchContainer.class, new RecipeBookGridMenuInfo<WorkbenchContainer, DefaultCraftingDisplay>(){

            @Override
            public List<List<ItemStack>> getInputs(MenuInfoContext<WorkbenchContainer, ?, DefaultCraftingDisplay> context) {
                return context.getDisplay().getOrganisedInputEntries(this, context.getMenu());
            }
        });
        registry.register(BuiltinPlugin.CRAFTING, PlayerContainer.class, new RecipeBookGridMenuInfo<PlayerContainer, DefaultCraftingDisplay>(){

            @Override
            public List<List<ItemStack>> getInputs(MenuInfoContext<PlayerContainer, ?, DefaultCraftingDisplay> context) {
                return context.getDisplay().getOrganisedInputEntries(this, context.getMenu());
            }
        });
        registry.register(BuiltinPlugin.SMELTING, FurnaceContainer.class, new RecipeBookGridMenuInfo());
        registry.register(BuiltinPlugin.SMOKING, SmokerContainer.class, new RecipeBookGridMenuInfo());
        registry.register(BuiltinPlugin.BLASTING, BlastFurnaceContainer.class, new RecipeBookGridMenuInfo());
    }

    @Override
    public int getPriority() {
        return -100;
    }
}

