/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.brewing;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.brewing.BrewingRecipe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class DefaultBrewingDisplay
implements Display {
    private EntryStack<?> output;
    private EntryIngredient reactant;
    private EntryIngredient input;

    public DefaultBrewingDisplay(BrewingRecipe recipe) {
        this(recipe.input, recipe.ingredient, recipe.output);
    }

    public DefaultBrewingDisplay(Ingredient input, Ingredient reactant, ItemStack output) {
        this(EntryIngredients.ofIngredient(input), EntryIngredients.ofIngredient(reactant), EntryStacks.of(output));
    }

    public DefaultBrewingDisplay(EntryIngredient input, EntryIngredient reactant, EntryStack<?> output) {
        this.input = input.map(stack -> stack.copy().tooltip(new ITextComponent[]{new TranslationTextComponent("category.rei.brewing.input").func_240699_a_(TextFormatting.YELLOW)}));
        this.reactant = reactant.map(stack -> stack.copy().tooltip(new ITextComponent[]{new TranslationTextComponent("category.rei.brewing.reactant").func_240699_a_(TextFormatting.YELLOW)}));
        this.output = output.copy().tooltip(new ITextComponent[]{new TranslationTextComponent("category.rei.brewing.result").func_240699_a_(TextFormatting.YELLOW)});
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return Lists.newArrayList((Object[])new EntryIngredient[]{this.input, this.reactant});
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(EntryIngredient.of(this.output));
    }

    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.BREWING;
    }

    public List<EntryStack<?>> getOutput(int slot) {
        int i;
        ArrayList stack = new ArrayList();
        for (i = 0; i < slot * 2; ++i) {
            stack.add(EntryStack.empty());
        }
        for (i = 0; i < 6 - slot * 2; ++i) {
            stack.add(this.output);
        }
        return stack;
    }

    public static DisplaySerializer<DefaultBrewingDisplay> serializer() {
        return new DisplaySerializer<DefaultBrewingDisplay>(){

            @Override
            public CompoundNBT save(CompoundNBT tag, DefaultBrewingDisplay display) {
                tag.func_218657_a("input", (INBT)display.input.save());
                tag.func_218657_a("reactant", (INBT)display.reactant.save());
                tag.func_218657_a("output", (INBT)display.output.save());
                return tag;
            }

            @Override
            public DefaultBrewingDisplay read(CompoundNBT tag) {
                EntryIngredient input = EntryIngredient.read(tag.func_150295_c("input", 10));
                EntryIngredient reactant = EntryIngredient.read(tag.func_150295_c("reactant", 10));
                EntryStack<?> output = EntryStack.read(tag.func_74775_l("output"));
                return new DefaultBrewingDisplay(input, reactant, output);
            }
        };
    }
}

