/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.cooking;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.display.SimpleMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import org.jetbrains.annotations.ApiStatus;

public abstract class DefaultCookingDisplay
extends BasicDisplay
implements SimpleMenuDisplay {
    private IRecipe<?> recipe;
    private float xp;
    private double cookTime;

    public DefaultCookingDisplay(AbstractCookingRecipe recipe) {
        this(EntryIngredients.ofIngredients((List<Ingredient>)recipe.func_192400_c()), Collections.singletonList(EntryIngredients.of(recipe.func_77571_b())), (IRecipe<?>)recipe, recipe.func_222138_b(), recipe.func_222137_e());
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, CompoundNBT tag) {
        this(input, output, RecipeManagerContext.getInstance().byId(tag, "location"), tag.func_74760_g("xp"), tag.func_74769_h("cookTime"));
    }

    public DefaultCookingDisplay(List<EntryIngredient> input, List<EntryIngredient> output, IRecipe<?> recipe, float xp, double cookTime) {
        super(input, output, Optional.ofNullable(recipe).map(IRecipe::func_199560_c));
        this.recipe = recipe;
        this.xp = xp;
        this.cookTime = cookTime;
    }

    public float getXp() {
        return this.xp;
    }

    public double getCookingTime() {
        return this.cookTime;
    }

    @ApiStatus.Internal
    public Optional<IRecipe<?>> getOptionalRecipe() {
        return Optional.ofNullable(this.recipe);
    }

    @Override
    public int getWidth() {
        return 1;
    }

    @Override
    public int getHeight() {
        return 1;
    }

    public static <R extends DefaultCookingDisplay> BasicDisplay.Serializer<R> serializer(BasicDisplay.Serializer.RecipeLessConstructor<R> constructor) {
        return BasicDisplay.Serializer.ofRecipeLess(constructor, (display, tag) -> {
            tag.func_74776_a("xp", display.getXp());
            tag.func_74780_a("cookTime", display.getCookingTime());
        });
    }
}

