/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleDisplaySerializer;
import me.shedaniel.rei.api.common.display.SimpleMenuDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.transfer.info.simple.SimpleGridMenuInfo;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import me.shedaniel.rei.plugin.common.BuiltinPlugin;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCustomDisplay;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;

public abstract class DefaultCraftingDisplay
implements SimpleMenuDisplay {
    @Override
    public CategoryIdentifier<?> getCategoryIdentifier() {
        return BuiltinPlugin.CRAFTING;
    }

    public abstract Optional<IRecipe<?>> getOptionalRecipe();

    public <T extends Container> List<List<ItemStack>> getOrganisedInputEntries(SimpleGridMenuInfo<T, DefaultCraftingDisplay> menuInfo, T container) {
        int i;
        ArrayList<List<ItemStack>> list = new ArrayList<List<ItemStack>>(menuInfo.getCraftingWidth(container) * menuInfo.getCraftingHeight(container));
        for (i = 0; i < menuInfo.getCraftingWidth(container) * menuInfo.getCraftingHeight(container); ++i) {
            list.add(Collections.emptyList());
        }
        for (i = 0; i < this.getInputEntries().size(); ++i) {
            List<ItemStack> stacks = CollectionUtils.filterAndMap(this.getInputEntries().get(i), stack -> stack.getType() == VanillaEntryTypes.ITEM, stack -> (ItemStack)stack.cast().getValue());
            list.set(DefaultCraftingDisplay.getSlotWithSize(this, i, menuInfo.getCraftingWidth(container)), stacks);
        }
        return list;
    }

    public static int getSlotWithSize(DefaultCraftingDisplay recipeDisplay, int num, int craftingGridWidth) {
        int x = num % recipeDisplay.getWidth();
        int y = (num - x) / recipeDisplay.getWidth();
        return craftingGridWidth * y + x;
    }

    public static enum Serializer implements SimpleDisplaySerializer<DefaultCraftingDisplay>
    {
        INSTANCE;


        @Override
        public DefaultCraftingDisplay read(CompoundNBT tag) {
            List<EntryIngredient> input = EntryIngredients.read(tag.func_150295_c("input", 9));
            List<EntryIngredient> output = EntryIngredients.read(tag.func_150295_c("output", 9));
            IRecipe optionalRecipe = tag.func_150297_b("recipe", 8) ? (IRecipe)RecipeManagerContext.getInstance().getRecipeManager().func_215367_a(new ResourceLocation(tag.func_74779_i("recipe"))).orElse(null) : null;
            return new DefaultCustomDisplay(optionalRecipe, input, output);
        }

        @Override
        public CompoundNBT saveExtra(CompoundNBT tag, DefaultCraftingDisplay display) {
            display.getOptionalRecipe().ifPresent(recipe -> tag.func_74778_a("recipe", recipe.func_199560_c().toString()));
            return tag;
        }
    }
}

