/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.common.displays.crafting;

import com.google.common.collect.ImmutableList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.plugin.common.displays.crafting.DefaultCraftingDisplay;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;

public class DefaultCustomDisplay
extends DefaultCraftingDisplay {
    private List<EntryIngredient> input;
    private List<EntryIngredient> output;
    private IRecipe<?> possibleRecipe;
    private int width;
    private int height;

    public DefaultCustomDisplay(IRecipe<?> possibleRecipe, List<EntryIngredient> input, List<EntryIngredient> output) {
        this.input = ImmutableList.copyOf(input);
        this.output = output;
        this.possibleRecipe = possibleRecipe;
        BitSet row = new BitSet(3);
        BitSet column = new BitSet(3);
        for (int i = 0; i < 9; ++i) {
            List stacks;
            if (i >= this.input.size() || !(stacks = (List)this.input.get(i)).stream().anyMatch(stack -> !stack.isEmpty())) continue;
            row.set((i - i % 3) / 3);
            column.set(i % 3);
        }
        this.width = row.cardinality();
        this.height = column.cardinality();
    }

    protected Optional<IRecipe<?>> getRecipe() {
        return Optional.ofNullable(this.possibleRecipe);
    }

    @Override
    public Optional<ResourceLocation> getDisplayLocation() {
        return this.getRecipe().map(IRecipe::func_199560_c);
    }

    @Override
    public List<EntryIngredient> getInputEntries() {
        return this.input;
    }

    @Override
    public List<EntryIngredient> getOutputEntries() {
        return this.output;
    }

    @Override
    public Optional<IRecipe<?>> getOptionalRecipe() {
        return Optional.ofNullable(this.possibleRecipe);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

