/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.plugin.test;

import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.client.registry.entry.EntryRegistry;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.comparison.ItemComparatorRegistry;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;

@OnlyIn(value=Dist.CLIENT)
public class REITestPlugin
implements REIClientPlugin {
    private Random random = new Random();

    @Override
    public void preRegister() {
        LogManager.getLogger().error("REI Test Plugin is enabled! If you see this unintentionally, please report this!");
    }

    @Override
    public void registerEntries(EntryRegistry registry) {
        int times = 100;
        for (Item item : Registry.field_212630_s) {
            EntryStack<ItemStack> base = EntryStacks.of((IItemProvider)item);
            registry.addEntriesAfter(base, IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of((IItemProvider)item))).collect(Collectors.toList()));
            try {
                for (ItemStack stack : registry.appendStacksForItem(item)) {
                    registry.addEntries(IntStream.range(0, times).mapToObj(value -> this.transformStack(EntryStacks.of(stack))).collect(Collectors.toList()));
                }
            }
            catch (Exception exception) {
            }
        }
    }

    @Override
    public void registerItemComparators(ItemComparatorRegistry registry) {
        registry.registerNbt((Item[])Registry.field_212630_s.func_201756_e().toArray(Item[]::new));
    }

    public EntryStack<ItemStack> transformStack(EntryStack<ItemStack> stack) {
        CompoundNBT tag = stack.getValue().func_196082_o();
        tag.func_74768_a("Whatever", this.random.nextInt(Integer.MAX_VALUE));
        return stack;
    }
}

