/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.server.command.EnumArgument;
import sereneseasons.api.season.Season;
import sereneseasons.handler.season.SeasonHandler;
import sereneseasons.season.SeasonSavedData;
import sereneseasons.season.SeasonTime;

public class CommandSetSeason {
    static ArgumentBuilder<CommandSource, ?> register() {
        return Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"season", (ArgumentType)EnumArgument.enumArgument(Season.SubSeason.class)).executes(ctx -> {
            ServerWorld world = ((CommandSource)ctx.getSource()).func_197023_e();
            return CommandSetSeason.setSeason((CommandSource)ctx.getSource(), (World)world, (Season.SubSeason)ctx.getArgument("season", Season.SubSeason.class));
        }));
    }

    private static int setSeason(CommandSource cs, World world, Season.SubSeason season) throws CommandException {
        if (season != null) {
            SeasonSavedData seasonData = SeasonHandler.getSeasonSavedData(world);
            seasonData.seasonCycleTicks = SeasonTime.ZERO.getSubSeasonDuration() * season.ordinal();
            seasonData.func_76185_a();
            SeasonHandler.sendSeasonUpdate(world);
            cs.func_197030_a((ITextComponent)new TranslationTextComponent("commands.sereneseasons.setseason.success", new Object[]{season.toString()}), true);
        } else {
            cs.func_197021_a((ITextComponent)new TranslationTextComponent("commands.sereneseasons.setseason.fail", new Object[]{season.toString()}));
        }
        return 1;
    }
}

