/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import sereneseasons.config.json.BiomeData;
import sereneseasons.util.biome.BiomeUtil;
import sereneseasons.util.config.JsonUtil;

public class BiomeConfig {
    public static final Map<ResourceLocation, BiomeData> biomeDataMap = Maps.newHashMap();

    public static void init(File configDir) {
        HashMap defaultBiomeData = Maps.newHashMap();
        BiomeConfig.addBlacklistedBiomes(defaultBiomeData);
        BiomeConfig.addTropicalBiomes(defaultBiomeData);
        biomeDataMap.clear();
        Map tmpBiomeDataMap = JsonUtil.getOrCreateConfigFile(configDir, "biome_info.json", defaultBiomeData, new TypeToken<Map<String, BiomeData>>(){}.getType());
        if (tmpBiomeDataMap != null && !tmpBiomeDataMap.isEmpty()) {
            for (Map.Entry entry : tmpBiomeDataMap.entrySet()) {
                biomeDataMap.put(new ResourceLocation((String)entry.getKey()), (BiomeData)entry.getValue());
            }
        }
    }

    public static boolean enablesSeasonalEffects(RegistryKey<Biome> biome) {
        ResourceLocation name = biome.func_240901_a_();
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).enableSeasonalEffects;
        }
        return true;
    }

    public static boolean usesTropicalSeasons(RegistryKey<Biome> key) {
        ResourceLocation name = key.func_240901_a_();
        Biome biome = BiomeUtil.getBiome(key);
        if (biomeDataMap.containsKey(name)) {
            return BiomeConfig.biomeDataMap.get((Object)name).useTropicalSeasons;
        }
        return biome.func_242445_k() > 0.8f;
    }

    public static boolean infertileBiome(RegistryKey<Biome> biome) {
        String name;
        ArrayList infertileBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:nether_wastes", "minecraft:soul_sand_valley", "minecraft:crimson_forest", "minecraft:warped_forest", "minecraft:basalt_deltas", "minecraft:the_end", "minecraft:small_end_islands", "minecraft:end_midlands", "minecraft:end_highlands", "minecraft:end_barrens", "minecraft:the_void", "biomesoplenty:ominous_woods", "biomesoplenty:ominous_mire", "biomesoplenty:volcano", "biomesoplenty:volcanic_plains", "biomesoplenty:wasteland", "biomesoplenty:wooded_wasteland", "biomesoplenty:crystalline_chasm", "biomesoplenty:undergrowth", "biomesoplenty:visercal_heap", "biomesoplenty:withered_abyss"});
        return infertileBiomes.contains(name = biome.func_240901_a_().toString());
    }

    public static boolean lessColorChange(RegistryKey<Biome> biome) {
        String name;
        ArrayList lessColorChangeBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:swamp", "minecraft:swamp_hills", "biomesoplenty:mystic_grove", "biomesoplenty:mystic_plains", "biomesoplenty:tundra", "biomesoplenty:tundra_basin", "biomesoplenty:tundra_bog", "biomesoplenty:ominous_woods", "biomesoplenty:ominous_mire"});
        return lessColorChangeBiomes.contains(name = biome.func_240901_a_().toString());
    }

    private static void addBlacklistedBiomes(Map<String, BiomeData> map) {
        ArrayList blacklistedBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:mushroom_fields", "minecraft:mushroom_fields_shore", "minecraft:ocean", "minecraft:deep_ocean", "minecraft:frozen_ocean", "minecraft:deep_frozen_ocean", "minecraft:cold_ocean", "minecraft:deep_cold_ocean", "minecraft:lukewarm_ocean", "minecraft:deep_lukewarm_ocean", "minecraft:warm_ocean", "minecraft:deep_warm_ocean", "minecraft:river", "minecraft:the_void", "biomesoplenty:origin_valley", "biomesoplenty:rainbow_hills"});
        for (String biomeName : blacklistedBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(false, false));
                continue;
            }
            map.get((Object)biomeName).enableSeasonalEffects = false;
        }
    }

    private static void addTropicalBiomes(Map<String, BiomeData> map) {
        ArrayList tropicalBiomes = Lists.newArrayList((Object[])new String[]{"minecraft:swamp", "minecraft:swamp_hills", "minecraft:warm_ocean", "minecraft:deep_warm_ocean"});
        for (String biomeName : tropicalBiomes) {
            if (!map.containsKey(biomeName)) {
                map.put(biomeName, new BiomeData(true, true));
                continue;
            }
            map.get((Object)biomeName).useTropicalSeasons = true;
        }
    }
}

