/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.init;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.registries.ForgeRegistries;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.FertilityConfig;
import sereneseasons.config.SeasonsConfig;

public class ModFertility {
    private static HashSet<String> springPlants = new HashSet();
    private static HashSet<String> summerPlants = new HashSet();
    private static HashSet<String> autumnPlants = new HashSet();
    private static HashSet<String> winterPlants = new HashSet();
    private static HashSet<String> allListedPlants = new HashSet();
    private static HashMap<String, Integer> seedSeasons = new HashMap();

    public static void init() {
        ModFertility.initSeasonCrops((List)FertilityConfig.springCrops.get(), springPlants, 1);
        ModFertility.initSeasonCrops((List)FertilityConfig.summerCrops.get(), summerPlants, 2);
        ModFertility.initSeasonCrops((List)FertilityConfig.autumnCrops.get(), autumnPlants, 4);
        ModFertility.initSeasonCrops((List)FertilityConfig.winterCrops.get(), winterPlants, 8);
    }

    public static boolean isCropFertile(String cropName, World world, BlockPos pos) {
        Season season = SeasonHelper.getSeasonState(world).getSeason();
        Biome biome = world.func_226691_t_(pos);
        RegistryKey biomeKey = world.func_242406_i(pos).orElse(null);
        if ((Integer)FertilityConfig.undergroundFertilityLevel.get() > -1 && pos.func_177956_o() < (Integer)FertilityConfig.undergroundFertilityLevel.get() && !world.func_226660_f_(pos)) {
            return true;
        }
        if (BiomeConfig.infertileBiome((RegistryKey<Biome>)biomeKey)) {
            return false;
        }
        if (!(((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && BiomeConfig.enablesSeasonalEffects((RegistryKey<Biome>)biomeKey) && SeasonsConfig.isDimensionWhitelisted((RegistryKey<World>)world.func_234923_W_()))) {
            return true;
        }
        if (BiomeConfig.usesTropicalSeasons((RegistryKey<Biome>)biomeKey)) {
            return summerPlants.contains(cropName) || !allListedPlants.contains(cropName);
        }
        if (biome.func_225486_c(pos) < 0.15f) {
            return winterPlants.contains(cropName);
        }
        if (season == Season.SPRING && springPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.SUMMER && summerPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.AUTUMN && autumnPlants.contains(cropName)) {
            return true;
        }
        if (season == Season.WINTER && winterPlants.contains(cropName)) {
            return true;
        }
        if (!allListedPlants.contains(cropName)) {
            if (season == Season.WINTER) {
                return (Boolean)FertilityConfig.ignoreUnlistedCrops.get();
            }
            return true;
        }
        return false;
    }

    private static void initSeasonCrops(List<String> seeds, HashSet<String> cropSet, int bitmask) {
        for (String seed : seeds) {
            BlockItem blockItem;
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(seed));
            BlockItem blockItem2 = blockItem = item instanceof BlockItem ? (BlockItem)item : null;
            if (blockItem != null && blockItem.func_179223_d() instanceof IPlantable) {
                String plantName = blockItem.func_179223_d().getRegistryName().toString();
                cropSet.add(plantName);
                if (bitmask == 0) continue;
                allListedPlants.add(plantName);
                if (seedSeasons.containsKey(seed)) {
                    int seasons = seedSeasons.get(seed);
                    seedSeasons.put(seed, seasons | bitmask);
                    continue;
                }
                seedSeasons.put(seed, bitmask);
                continue;
            }
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(seed));
            if (block == null || block == Blocks.field_150350_a) continue;
            String plantName = block.getRegistryName().toString();
            cropSet.add(plantName);
            if (bitmask == 0) continue;
            allListedPlants.add(plantName);
            if (seedSeasons.containsKey(seed)) {
                int seasons = seedSeasons.get(seed);
                seedSeasons.put(seed, seasons | bitmask);
                continue;
            }
            seedSeasons.put(seed, bitmask);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void setupTooltips(ItemTooltipEvent event) {
        String name;
        if (((Boolean)FertilityConfig.cropTooltips.get()).booleanValue() && ((Boolean)FertilityConfig.seasonalCrops.get()).booleanValue() && seedSeasons.containsKey(name = event.getItemStack().func_77973_b().getRegistryName().toString())) {
            int mask = seedSeasons.get(name);
            event.getToolTip().add(new TranslationTextComponent("desc.sereneseasons.fertile_seasons").func_240702_b_(":"));
            if ((mask & 1) != 0 && (mask & 2) != 0 && (mask & 4) != 0 && (mask & 8) != 0) {
                event.getToolTip().add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.year_round").func_240699_a_(TextFormatting.LIGHT_PURPLE)));
            } else {
                if ((mask & 1) != 0) {
                    event.getToolTip().add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.spring").func_240699_a_(TextFormatting.GREEN)));
                }
                if ((mask & 2) != 0) {
                    event.getToolTip().add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.summer").func_240699_a_(TextFormatting.YELLOW)));
                }
                if ((mask & 4) != 0) {
                    event.getToolTip().add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.autumn").func_240699_a_(TextFormatting.GOLD)));
                }
                if ((mask & 8) != 0) {
                    event.getToolTip().add(new StringTextComponent(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("desc.sereneseasons.winter").func_240699_a_(TextFormatting.AQUA)));
                }
            }
        }
    }
}

