/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.mixin.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;
import sereneseasons.config.BiomeConfig;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonHooks;
import sereneseasons.util.biome.BiomeUtil;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer
implements IResourceManagerReloadListener,
AutoCloseable {
    @Redirect(method={"renderSnowAndRain", "renderRainSnow"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getPrecipitation()Lnet/minecraft/world/biome/Biome$RainType;"))
    public Biome.RainType renderSnowAndRain_getPrecipitation(Biome biome) {
        return MixinWorldRenderer.getSeasonalPrecipitation(biome);
    }

    @Redirect(method={"tickRain", "addRainParticles"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/biome/Biome;getPrecipitation()Lnet/minecraft/world/biome/Biome$RainType;"))
    public Biome.RainType tickRain_getPrecipitation(Biome biome) {
        return MixinWorldRenderer.getSeasonalPrecipitation(biome);
    }

    private static Biome.RainType getSeasonalPrecipitation(Biome biome) {
        RegistryKey<Biome> biomeKey = BiomeUtil.getBiomeKey(biome);
        Biome.RainType rainType = biome.func_201851_b();
        ClientWorld world = Minecraft.func_71410_x().field_71441_e;
        if (SeasonsConfig.isDimensionWhitelisted((RegistryKey<World>)world.func_234923_W_()) && BiomeConfig.enablesSeasonalEffects(biomeKey) && (rainType == Biome.RainType.RAIN || rainType == Biome.RainType.NONE)) {
            if (SeasonHooks.shouldRainInBiomeInSeason((World)world, biomeKey)) {
                return Biome.RainType.RAIN;
            }
            return Biome.RainType.NONE;
        }
        return rainType;
    }
}

