/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.util.biome;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import sereneseasons.core.SereneSeasons;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BiomeUtil {
    private static List<World> worldList = Lists.newArrayList();

    public static RegistryKey<Biome> getBiomeKey(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Cannot get registry key for null biome");
        }
        if (biome.delegate.name() == null) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                return BiomeUtil.getClientKey(biome);
            }
            throw new RuntimeException("Failed to get registry key for biome!");
        }
        return RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)biome.delegate.name());
    }

    public static Biome getBiome(RegistryKey<Biome> key) {
        Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(key.func_240901_a_());
        if (biome == null) {
            if (FMLEnvironment.dist == Dist.CLIENT) {
                try {
                    biome = BiomeUtil.getClientBiome(key);
                }
                catch (Exception e) {
                    SereneSeasons.logger.error(e.getMessage());
                }
                if (biome == null) {
                    biome = BiomeUtil.getBiomeFromWorlds(key);
                }
                return biome;
            }
            if (FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
                return BiomeUtil.getBiomeFromWorlds(key);
            }
        }
        return biome;
    }

    public static Biome getBiome(int id) {
        if (id == -1) {
            throw new RuntimeException("Attempted to get biome with id -1");
        }
        return BiomeUtil.getBiome((RegistryKey<Biome>)((ForgeRegistry)ForgeRegistries.BIOMES).getKey(id));
    }

    public static int getBiomeId(Biome biome) {
        if (biome == null) {
            throw new RuntimeException("Attempted to get id of null biome");
        }
        int id = ((ForgeRegistry)ForgeRegistries.BIOMES).getID((IForgeRegistryEntry)biome);
        if (id == -1) {
            throw new RuntimeException("Biome id is -1 for biome " + biome.delegate.name());
        }
        return id;
    }

    public static int getBiomeId(RegistryKey<Biome> key) {
        return BiomeUtil.getBiomeId(BiomeUtil.getBiome(key));
    }

    public static boolean exists(RegistryKey<Biome> key) {
        return ForgeRegistries.BIOMES.containsKey(key.func_240901_a_());
    }

    public static boolean exists(int id) {
        return BiomeUtil.getBiome(id) != null;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Registry<Biome> getClientBiomeRegistry() {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientWorld world = minecraft.field_71441_e;
        if (world == null) {
            throw new RuntimeException("Cannot acquire biome registry when the world is null.");
        }
        return world.func_241828_r().func_243612_b(Registry.field_239720_u_);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static RegistryKey<Biome> getClientKey(Biome biome) {
        return (RegistryKey)BiomeUtil.getClientBiomeRegistry().func_230519_c_((Object)biome).orElseThrow(() -> new RuntimeException("Failed to get client registry key for biome!"));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static Biome getClientBiome(RegistryKey<Biome> key) {
        Biome biome = (Biome)BiomeUtil.getClientBiomeRegistry().func_230516_a_(key);
        if (biome == null) {
            new RuntimeException("Failed to get client biome for registry key " + key.func_240901_a_().toString() + "!");
        }
        return biome;
    }

    private static Biome getBiomeFromWorlds(RegistryKey<Biome> key) {
        for (World world : worldList) {
            Biome biome = (Biome)world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_230516_a_(key);
            if (biome == null) continue;
            return biome;
        }
        throw new RuntimeException("Failed to get biome for registry key " + key.func_240901_a_().toString() + " !");
    }

    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        worldList.add((World)event.getWorld());
    }

    @SubscribeEvent
    public static void onWorldUnload(WorldEvent.Unload event) {
        worldList.remove((World)event.getWorld());
    }
}

