/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.electricfurnace;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.AbstractCookingRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.mechanisms.block.AbstractMachineTileEntity;
import net.silentchaos512.mechanisms.block.electricfurnace.ElectricFurnaceContainer;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class ElectricFurnaceTileEntity
extends AbstractMachineTileEntity<AbstractCookingRecipe> {
    public static final int MAX_ENERGY = 50000;
    public static final int MAX_RECEIVE = 500;
    public static final int ENERGY_USED_PER_TICK = 30;
    private static final int INVENTORY_SIZE = 2;
    private static final int[] SLOTS_INPUT = new int[]{0};
    private static final int[] SLOTS_OUTPUT = new int[]{1};
    private static final int[] SLOTS_ALL = new int[]{0, 1};

    public ElectricFurnaceTileEntity() {
        super(ModTileEntities.electricFurnace, 2, MachineTier.STANDARD);
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 30;
    }

    @Override
    protected int[] getOutputSlots() {
        return SLOTS_OUTPUT;
    }

    @Override
    @Nullable
    protected AbstractCookingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        RecipeManager recipeManager = this.field_145850_b.func_199532_z();
        Optional optional = recipeManager.func_215371_a(IRecipeType.field_222151_c, (IInventory)this, this.field_145850_b);
        if (optional.isPresent()) {
            return (AbstractCookingRecipe)optional.get();
        }
        Optional optional1 = recipeManager.func_215371_a(IRecipeType.field_222150_b, (IInventory)this, this.field_145850_b);
        return optional1.orElse(null);
    }

    @Override
    protected int getProcessTime(AbstractCookingRecipe recipe) {
        return recipe.func_222137_e();
    }

    @Override
    protected Collection<ItemStack> getProcessResults(AbstractCookingRecipe recipe) {
        return Collections.singleton(recipe.func_77572_b((IInventory)this));
    }

    public int[] func_180463_a(Direction side) {
        if (side == Direction.UP) {
            return SLOTS_INPUT;
        }
        if (side == Direction.DOWN) {
            return SLOTS_OUTPUT;
        }
        return SLOTS_ALL;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "electric_furnace", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory playerInventory) {
        return new ElectricFurnaceContainer(id, playerInventory, this, this.fields);
    }

    List<String> getDebugText() {
        return ImmutableList.of((Object)("progress = " + this.progress), (Object)("processTime = " + this.processTime), (Object)("energy = " + this.getEnergyStored() + " FE / " + this.getMaxEnergyStored() + " FE"), (Object)"ENERGY_USED_PER_TICK = 30", (Object)"MAX_RECEIVE = 500");
    }
}

