/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.crafting.recipe;

import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.FluidIngredient;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidInventory;
import net.silentchaos512.mechanisms.api.crafting.recipe.fluid.IFluidRecipe;

public class SolidifyingRecipe
implements IFluidRecipe<IFluidInventory> {
    public static final IRecipeType<SolidifyingRecipe> RECIPE_TYPE = IRecipeType.func_222147_a((String)SilentMechanisms.getId("solidifying").toString());
    public static final Serializer SERIALIZER = new Serializer();
    private final ResourceLocation recipeId;
    private int processTime;
    private FluidIngredient ingredient;
    private ItemStack result;

    public SolidifyingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public FluidIngredient getIngredient() {
        return this.ingredient;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public boolean matches(IFluidInventory inv, World worldIn) {
        return this.ingredient.test(inv.getFluidInTank(0));
    }

    @Override
    public List<FluidStack> getFluidResults(IFluidInventory inv) {
        return this.getFluidOutputs();
    }

    @Override
    public List<FluidStack> getFluidOutputs() {
        return Collections.emptyList();
    }

    @Override
    public List<FluidIngredient> getFluidIngredients() {
        return Collections.singletonList(this.ingredient);
    }

    @Override
    public ItemStack getCraftingResult(IFluidInventory inv) {
        return this.func_77571_b();
    }

    @Override
    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return RECIPE_TYPE;
    }

    public static class Serializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<SolidifyingRecipe> {
        public SolidifyingRecipe read(ResourceLocation recipeId, JsonObject json) {
            SolidifyingRecipe recipe = new SolidifyingRecipe(recipeId);
            recipe.processTime = JSONUtils.func_151203_m((JsonObject)json, (String)"process_time");
            recipe.ingredient = FluidIngredient.deserialize(json.getAsJsonObject("ingredient"));
            recipe.result = ShapedRecipe.func_199798_a((JsonObject)JSONUtils.func_152754_s((JsonObject)json, (String)"result"));
            return recipe;
        }

        @Nullable
        public SolidifyingRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
            SolidifyingRecipe recipe = new SolidifyingRecipe(recipeId);
            recipe.processTime = buffer.func_150792_a();
            recipe.ingredient = FluidIngredient.read(buffer);
            recipe.result = buffer.func_150791_c();
            return recipe;
        }

        public void write(PacketBuffer buffer, SolidifyingRecipe recipe) {
            buffer.func_150787_b(recipe.processTime);
            recipe.ingredient.write(buffer);
            buffer.func_150788_a(recipe.result);
        }
    }
}

