/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.network;

import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseContainer;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.utils.EnumUtils;

public class SetRedstoneModePacket {
    private RedstoneMode mode;

    public SetRedstoneModePacket() {
    }

    public SetRedstoneModePacket(RedstoneMode mode) {
        this.mode = mode;
    }

    public static SetRedstoneModePacket fromBytes(PacketBuffer buffer) {
        SetRedstoneModePacket packet = new SetRedstoneModePacket();
        packet.mode = (RedstoneMode)EnumUtils.byOrdinal((int)buffer.readByte(), (Enum)RedstoneMode.IGNORED);
        return packet;
    }

    public void toBytes(PacketBuffer buffer) {
        buffer.writeByte(this.mode.ordinal());
    }

    public static void handle(SetRedstoneModePacket packet, Supplier<NetworkEvent.Context> context) {
        ServerPlayerEntity player = context.get().getSender();
        context.get().enqueueWork(() -> SetRedstoneModePacket.handlePacket(packet, player));
        context.get().setPacketHandled(true);
    }

    private static void handlePacket(SetRedstoneModePacket packet, ServerPlayerEntity player) {
        Object tileEntity;
        if (player != null && player.field_71070_bA instanceof AbstractMachineBaseContainer && (tileEntity = ((AbstractMachineBaseContainer)player.field_71070_bA).getTileEntity()) instanceof AbstractMachineBaseTileEntity) {
            ((AbstractMachineBaseTileEntity)tileEntity).setRedstoneMode(packet.mode);
        }
    }
}

