/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.Fluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLDedicatedServerSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.silentchaos512.lib.event.Greetings;
import net.silentchaos512.mechanisms.IProxy;
import net.silentchaos512.mechanisms.compat.computercraft.SMechComputerCraftCompat;
import net.silentchaos512.mechanisms.config.Config;
import net.silentchaos512.mechanisms.data.DataGenerators;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.ModContainers;
import net.silentchaos512.mechanisms.init.ModFluids;
import net.silentchaos512.mechanisms.init.ModItems;
import net.silentchaos512.mechanisms.init.ModRecipes;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.init.Registration;
import net.silentchaos512.mechanisms.network.Network;
import net.silentchaos512.mechanisms.world.SMWorldFeatures;

class SideProxy
implements IProxy {
    private MinecraftServer server = null;

    SideProxy() {
        Config.init();
        Network.init();
        Registration.register();
        FMLJavaModLoadingContext.get().getModEventBus().addListener(DataGenerators::gatherData);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcEnqueue);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imcProcess);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(ContainerType.class, ModContainers::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Fluid.class, ModFluids::registerFluids);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, ModItems::registerAll);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(TileEntityType.class, ModTileEntities::registerAll);
        MinecraftForge.EVENT_BUS.addListener(this::serverAboutToStart);
        ModRecipes.init();
        Greetings.addMessage(SideProxy::getBetaWelcomeMessage);
        Greetings.addMessage(ModBlocks::checkForMissingLootTables);
    }

    @Nullable
    private static ITextComponent getBetaWelcomeMessage(PlayerEntity p) {
        return (Boolean)Config.showBetaWelcomeMessage.get() != false ? new StringTextComponent("Thanks for trying Silent's Mechanisms! This mod is early in development, expect bugs and changes.") : null;
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        DeferredWorkQueue.runLater(SMWorldFeatures::addFeaturesToBiomes);
        if (ModList.get().isLoaded("computercraft")) {
            SMechComputerCraftCompat.init();
        }
    }

    private void imcEnqueue(InterModEnqueueEvent event) {
    }

    private void imcProcess(InterModProcessEvent event) {
    }

    private void serverAboutToStart(FMLServerAboutToStartEvent event) {
        this.server = event.getServer();
    }

    @Override
    public MinecraftServer getServer() {
        return this.server;
    }

    static class Server
    extends SideProxy {
        Server() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::serverSetup);
        }

        private void serverSetup(FMLDedicatedServerSetupEvent event) {
        }
    }

    static class Client
    extends SideProxy {
        Client() {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(ModItems::registerItemColors);
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
            MinecraftForge.EVENT_BUS.addListener(this::setFog);
        }

        private void clientSetup(FMLClientSetupEvent event) {
            ModBlocks.registerRenderTypes(event);
            ModContainers.registerScreens(event);
            ModTileEntities.registerRenderers(event);
        }

        public void setFog(EntityViewRenderEvent.FogColors fog) {
            float blue;
            float green;
            float red;
            BlockPos pos;
            World w = fog.getInfo().func_216773_g().func_130014_f_();
            BlockState bs = w.func_180495_p(pos = fog.getInfo().func_216780_d());
            Block b = bs.func_177230_c();
            if (b.equals(ModBlocks.OIL)) {
                red = 0.02f;
                green = 0.02f;
                blue = 0.02f;
                fog.setRed(red);
                fog.setGreen(green);
                fog.setBlue(blue);
            }
            if (b.equals(ModBlocks.DIESEL)) {
                red = 0.9f;
                green = 0.9f;
                blue = 0.02f;
                fog.setRed(red);
                fog.setGreen(green);
                fog.setBlue(blue);
            }
        }
    }
}

