/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.pipe;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.pipe.PipeNetwork;

@Mod.EventBusSubscriber(modid="silents_mechanisms")
public final class PipeNetworkManager {
    private static final Collection<LazyOptional<PipeNetwork>> NETWORK_LIST = Collections.synchronizedList(new ArrayList());

    private PipeNetworkManager() {
        throw new IllegalAccessError("Utility class");
    }

    @Nullable
    public static PipeNetwork get(IWorldReader world, BlockPos pos) {
        return (PipeNetwork)PipeNetworkManager.getLazy(world, pos).orElse(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LazyOptional<PipeNetwork> getLazy(IWorldReader world, BlockPos pos) {
        Collection<LazyOptional<PipeNetwork>> collection = NETWORK_LIST;
        synchronized (collection) {
            for (LazyOptional<PipeNetwork> network : NETWORK_LIST) {
                PipeNetwork net;
                if (!network.isPresent() || !(net = (PipeNetwork)network.orElseThrow(IllegalStateException::new)).contains(world, pos)) continue;
                return network;
            }
        }
        PipeNetwork network = PipeNetwork.buildNetwork(world, pos);
        LazyOptional lazy = LazyOptional.of(() -> network);
        NETWORK_LIST.add((LazyOptional<PipeNetwork>)lazy);
        SilentMechanisms.LOGGER.debug("create network {}", (Object)network);
        return lazy;
    }

    public static void invalidateNetwork(IWorldReader world, BlockPos pos) {
        Collection toRemove = NETWORK_LIST.stream().filter(n -> n != null && n.isPresent() && ((PipeNetwork)n.orElseThrow(IllegalStateException::new)).contains(world, pos)).collect(Collectors.toList());
        toRemove.forEach(PipeNetworkManager::invalidateNetwork);
    }

    private static void invalidateNetwork(LazyOptional<PipeNetwork> network) {
        SilentMechanisms.LOGGER.debug("invalidateNetwork {}", network);
        NETWORK_LIST.removeIf(n -> n.isPresent() && n.equals(network));
        network.ifPresent(PipeNetwork::invalidate);
        network.invalidate();
    }

    @SubscribeEvent
    public static void onServerTick(TickEvent.ServerTickEvent event) {
        NETWORK_LIST.stream().filter(n -> n != null && n.isPresent()).forEach(n -> n.ifPresent(PipeNetwork::moveFluids));
    }
}

