/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Blocks;
import net.minecraft.data.CookingRecipeBuilder;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.data.recipes.AlloySmeltingRecipeBuilder;
import net.silentchaos512.mechanisms.data.recipes.CompressingRecipeBuilder;
import net.silentchaos512.mechanisms.data.recipes.CrushingRecipeBuilder;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModTags;
import net.silentchaos512.mechanisms.item.CraftingItems;

public class ModRecipesProvider
extends RecipeProvider {
    private static final int CRUSHING_CHUNKS_TIME = 300;
    private static final int CRUSHING_INGOT_TIME = 200;
    private static final int CRUSHING_ORE_TIME = 400;
    private static final float CRUSHING_CHUNKS_EXTRA_CHANCE = 0.1f;
    private static final float CRUSHING_ORE_STONE_CHANCE = 0.1f;

    public ModRecipesProvider(DataGenerator generatorIn) {
        super(generatorIn);
    }

    public String func_200397_b() {
        return "Silent's Mechanisms - Recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        this.registerSmelting(consumer);
        ModRecipesProvider.registerAlloySmelting(consumer);
        ModRecipesProvider.registerCompressingRecipes(consumer);
        ModRecipesProvider.registerCrushingRecipes(consumer);
    }

    private void registerSmelting(Consumer<IFinishedRecipe> consumer) {
        for (Metals metal : Metals.values()) {
            if (metal.getIngot().isPresent() && (metal.getChunksTag().isPresent() || metal.getDustTag().isPresent())) {
                this.smeltingAndBlasting(consumer, metal.getName() + "_ingot", metal.getSmeltables(false), (IItemProvider)metal.getIngot().get());
            }
            if (!metal.getIngot().isPresent() || !metal.getOreItemTag().isPresent()) continue;
            this.smeltingAndBlasting(consumer, metal.getName() + "_ingot_from_ore", Ingredient.func_199805_a(metal.getOreItemTag().get()), (IItemProvider)metal.getIngot().get());
        }
        this.smeltingAndBlasting(consumer, "iron_ingot", Metals.IRON.getSmeltables(false), (IItemProvider)Items.field_151042_j);
        this.smeltingAndBlasting(consumer, "gold_ingot", Metals.GOLD.getSmeltables(false), (IItemProvider)Items.field_151043_k);
        assert (Metals.REFINED_IRON.getIngot().isPresent());
        this.smeltingAndBlasting(consumer, "refined_iron_ingot", Ingredient.func_199805_a((Tag)Tags.Items.INGOTS_IRON), (IItemProvider)Metals.REFINED_IRON.getIngot().get());
    }

    private void smeltingAndBlasting(Consumer<IFinishedRecipe> consumer, String name, Ingredient ingredient, IItemProvider result) {
        CookingRecipeBuilder.func_218629_c((Ingredient)ingredient, (IItemProvider)result, (float)1.0f, (int)200).func_218628_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_150460_al)).func_218635_a(consumer, SilentMechanisms.getId("smelting/" + name));
        CookingRecipeBuilder.func_218633_b((Ingredient)ingredient, (IItemProvider)result, (float)1.0f, (int)100).func_218628_a("has_item", (ICriterionInstance)this.func_200403_a((IItemProvider)Blocks.field_150460_al)).func_218635_a(consumer, SilentMechanisms.getId("blasting/" + name));
    }

    private static void registerAlloySmelting(Consumer<IFinishedRecipe> consumer) {
        AlloySmeltingRecipeBuilder.builder(Metals.ALUMINUM_STEEL, 4, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 3).ingredient(Metals.ALUMINUM, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BISMUTH_BRASS, 4, 400).ingredient(Metals.COPPER, 2).ingredient(Metals.ZINC, 1).ingredient(Metals.BISMUTH, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BISMUTH_STEEL, 4, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 3).ingredient(Metals.BISMUTH, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BRASS, 4, 400).ingredient(Metals.COPPER, 3).ingredient(Metals.ZINC, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.BRONZE, 4, 400).ingredient(Metals.COPPER, 3).ingredient(Metals.TIN, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.ELECTRUM, 2, 400).ingredient(Metals.GOLD, 1).ingredient(Metals.SILVER, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.ENDERIUM, 4, 500).ingredient(Metals.LEAD, 3).ingredient(Metals.PLATINUM, 1).ingredient((Tag<Item>)Tags.Items.ENDER_PEARLS, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.INVAR, 3, 400).ingredient(Metals.IRON, 2).ingredient(Metals.NICKEL, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.LUMIUM, 4, 500).ingredient(Metals.TIN, 3).ingredient(Metals.SILVER, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_GLOWSTONE, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.REDSTONE_ALLOY, 2, 200).ingredient(Metals.IRON, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 4).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.SIGNALUM, 4, 500).ingredient(Metals.COPPER, 3).ingredient(Metals.SILVER, 1).ingredient((Tag<Item>)Tags.Items.DUSTS_REDSTONE, 10).build(consumer);
        AlloySmeltingRecipeBuilder.builder(CraftingItems.SOLDER, 12, 200).ingredient(Metals.TIN, 1).ingredient(Metals.LEAD, 1).build(consumer);
        AlloySmeltingRecipeBuilder.builder(Metals.STEEL, 2, 600).ingredient(Metals.IRON, 2).ingredient(ModTags.Items.DUSTS_COAL, 2).build(consumer);
    }

    private static void registerCompressingRecipes(Consumer<IFinishedRecipe> consumer) {
        CompressingRecipeBuilder.builder((IItemProvider)Items.field_151065_br, 4, (IItemProvider)Items.field_151072_bj, 1, 400).build(consumer);
        assert (Metals.COMPRESSED_IRON.getIngot().isPresent());
        CompressingRecipeBuilder.builder((Tag<Item>)Tags.Items.INGOTS_IRON, 1, (IItemProvider)Metals.COMPRESSED_IRON.getIngot().get(), 1, 400).build(consumer);
        CompressingRecipeBuilder.builder((Tag<Item>)Tags.Items.STORAGE_BLOCKS_COAL, 16, (IItemProvider)Items.field_151045_i, 1, 800).build(consumer);
    }

    private static void registerCrushingRecipes(Consumer<IFinishedRecipe> consumer) {
        for (Metals metal : Metals.values()) {
            if (metal.getOreItemTag().isPresent() && metal.getChunks().isPresent()) {
                ModRecipesProvider.crushingOre(metal.getOreItemTag().get(), (IItemProvider)metal.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
            }
            if (metal.getChunksTag().isPresent() && metal.getDust().isPresent()) {
                ModRecipesProvider.crushingChunks(metal.getChunksTag().get(), (IItemProvider)metal.getDust().get()).build(consumer);
            }
            if (!metal.getIngotTag().isPresent() || !metal.getDust().isPresent()) continue;
            ModRecipesProvider.crushingIngot(metal.getIngotTag().get(), (IItemProvider)metal.getDust().get()).build(consumer, SilentMechanisms.getId("crushing/" + metal.getName() + "_dust_from_ingot"));
        }
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_COAL, 400).result((IItemProvider)Items.field_151044_h, 2).result((IItemProvider)Items.field_221585_m, 1, 0.1f).result((IItemProvider)Items.field_151045_i, 1, 0.001f).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_LAPIS, 400).result((IItemProvider)Items.field_196128_bn, 12).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.ORES_REDSTONE, 400).result((IItemProvider)Items.field_151137_ax, 6).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_QUARTZ, (IItemProvider)Items.field_151128_bU).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_DIAMOND, (IItemProvider)Items.field_151045_i).build(consumer);
        ModRecipesProvider.crushingOreBonus((Tag<Item>)Tags.Items.ORES_EMERALD, (IItemProvider)Items.field_151166_bC).build(consumer);
        ModRecipesProvider.crushingOre((Tag<Item>)Tags.Items.ORES_GOLD, (IItemProvider)Metals.GOLD.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
        ModRecipesProvider.crushingOre((Tag<Item>)Tags.Items.ORES_IRON, (IItemProvider)Metals.IRON.getChunks().get(), (IItemProvider)Blocks.field_150347_e).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.RODS_BLAZE, 200).result((IItemProvider)Items.field_151065_br, 4).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150435_aG, 100).result((IItemProvider)Items.field_151119_aD, 4).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Items.field_151044_h, 200).result(CraftingItems.COAL_DUST, 1).build(consumer);
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150426_aN, 100).result((IItemProvider)Items.field_151114_aO, 4).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)Tags.Items.COBBLESTONE, 200).result((IItemProvider)Blocks.field_150351_n, 1).build(consumer);
        CrushingRecipeBuilder.builder((Tag<Item>)ItemTags.field_200038_h, 200).result((IItemProvider)Items.field_151121_aF, 1, 0.75f).result((IItemProvider)Items.field_151121_aF, 1, 0.25f).result((IItemProvider)Items.field_151055_y, 1, 0.25f).result((IItemProvider)Items.field_151055_y, 1, 0.25f).build(consumer);
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150371_ca, Blocks.field_196770_fj, Blocks.field_196772_fk, Blocks.field_196581_bI}), 200).result((IItemProvider)Items.field_151128_bU, 4).build(consumer, SilentMechanisms.getId("crushing/quartz_from_blocks"));
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_180395_cM, Blocks.field_196798_hA}), 200).result((IItemProvider)Blocks.field_196611_F, 4).build(consumer, SilentMechanisms.getId("crushing/red_sand_from_sandstone"));
        CrushingRecipeBuilder.builder(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150322_A, Blocks.field_196583_aj}), 200).result((IItemProvider)Blocks.field_150354_m, 4).build(consumer, SilentMechanisms.getId("crushing/sand_from_sandstone"));
        CrushingRecipeBuilder.builder((IItemProvider)Blocks.field_150351_n, 200).result((IItemProvider)Blocks.field_150354_m, 1).result((IItemProvider)Items.field_151145_ak, 1, 0.1f).build(consumer);
    }

    public static CrushingRecipeBuilder crushingChunks(Tag<Item> chunks, IItemProvider dust) {
        return CrushingRecipeBuilder.crushingChunks(chunks, dust, 300, 0.1f);
    }

    public static CrushingRecipeBuilder crushingIngot(Tag<Item> ingot, IItemProvider dust) {
        return CrushingRecipeBuilder.crushingIngot(ingot, dust, 200);
    }

    public static CrushingRecipeBuilder crushingOre(Tag<Item> ore, IItemProvider chunks, @Nullable IItemProvider extra) {
        return CrushingRecipeBuilder.crushingOre(ore, chunks, 400, extra, 0.1f);
    }

    public static CrushingRecipeBuilder crushingOreBonus(Tag<Item> ore, IItemProvider item) {
        return CrushingRecipeBuilder.builder(ore, 400).result(item, 2).result(item, 1, 0.1f).result((IItemProvider)Blocks.field_150347_e, 1, 0.1f);
    }
}

