/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.util;

import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.energy.IEnergyStorage;
import net.silentchaos512.mechanisms.block.IEnergyHandler;

public final class EnergyUtils {
    private EnergyUtils() {
        throw new IllegalAccessError("Utility class");
    }

    public static void trySendToNeighbors(IBlockReader world, BlockPos pos, IEnergyHandler energyHandler, int maxSend) {
        for (Direction side : Direction.values()) {
            if (energyHandler.getEnergyStored() == 0) {
                return;
            }
            EnergyUtils.trySendTo(world, pos, energyHandler, maxSend, side);
        }
    }

    public static void trySendTo(IBlockReader world, BlockPos pos, IEnergyHandler energyHandler, int maxSend, Direction side) {
        TileEntity tileEntity = world.func_175625_s(pos.func_177972_a(side));
        if (tileEntity != null) {
            IEnergyStorage energy = (IEnergyStorage)energyHandler.getEnergy(side).orElse((Object)new EnergyStorage(0));
            tileEntity.getCapability(CapabilityEnergy.ENERGY, side.func_176734_d()).ifPresent(other -> EnergyUtils.trySendEnergy(maxSend, energy, other));
        }
    }

    private static void trySendEnergy(int maxSend, IEnergyStorage energy, IEnergyStorage other) {
        int toSend;
        int sent;
        if (other.canReceive() && (sent = other.receiveEnergy(toSend = energy.extractEnergy(maxSend, true), false)) > 0) {
            energy.extractEnergy(sent, false);
        }
    }

    @Nullable
    public static IEnergyStorage getEnergy(IWorldReader world, BlockPos pos) {
        if (!world.isAreaLoaded(pos, 1)) {
            return null;
        }
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null ? (IEnergyStorage)tileEntity.getCapability(CapabilityEnergy.ENERGY).orElse(null) : null;
    }

    @Nullable
    public static IEnergyStorage getEnergy(ICapabilityProvider provider) {
        return (IEnergyStorage)provider.getCapability(CapabilityEnergy.ENERGY).orElse(null);
    }

    @Nullable
    public static IEnergyStorage getEnergyFromSideOrNull(ICapabilityProvider provider, Direction side) {
        return (IEnergyStorage)provider.getCapability(CapabilityEnergy.ENERGY, side).orElse(provider.getCapability(CapabilityEnergy.ENERGY).orElse(null));
    }
}

