/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.generator;

import net.minecraft.block.AbstractFurnaceBlock;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IIntArray;
import net.silentchaos512.mechanisms.api.RedstoneMode;
import net.silentchaos512.mechanisms.block.AbstractMachineBaseTileEntity;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.utils.EnumUtils;

public abstract class AbstractGeneratorTileEntity
extends AbstractMachineBaseTileEntity {
    public static final int FIELDS_COUNT = 7;
    protected int burnTime;
    protected int totalBurnTime;
    protected final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return AbstractGeneratorTileEntity.this.getEnergyStored() & 0xFFFF;
                }
                case 1: {
                    return AbstractGeneratorTileEntity.this.getEnergyStored() >> 16 & 0xFFFF;
                }
                case 2: {
                    return AbstractGeneratorTileEntity.this.getMaxEnergyStored() & 0xFFFF;
                }
                case 3: {
                    return AbstractGeneratorTileEntity.this.getMaxEnergyStored() >> 16 & 0xFFFF;
                }
                case 4: {
                    return AbstractGeneratorTileEntity.this.redstoneMode.ordinal();
                }
                case 5: {
                    return AbstractGeneratorTileEntity.this.burnTime;
                }
                case 6: {
                    return AbstractGeneratorTileEntity.this.totalBurnTime;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 4: {
                    AbstractGeneratorTileEntity.this.redstoneMode = (RedstoneMode)EnumUtils.byOrdinal((int)value, (Enum)RedstoneMode.IGNORED);
                    break;
                }
                case 5: {
                    AbstractGeneratorTileEntity.this.burnTime = value;
                    break;
                }
                case 6: {
                    AbstractGeneratorTileEntity.this.totalBurnTime = value;
                }
            }
        }

        public int func_221478_a() {
            return 7;
        }
    };

    protected AbstractGeneratorTileEntity(TileEntityType<?> typeIn, int inventorySize, int maxEnergy, int maxReceive, int maxExtract, MachineTier tier) {
        super(typeIn, inventorySize, maxEnergy, maxReceive, maxExtract, tier);
    }

    protected abstract boolean hasFuel();

    protected abstract void consumeFuel();

    protected abstract int getEnergyCreatedPerTick();

    protected BlockState getActiveState() {
        return (BlockState)this.func_195044_w().func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(true));
    }

    protected BlockState getInactiveState() {
        return (BlockState)this.func_195044_w().func_206870_a((Property)AbstractFurnaceBlock.field_220091_b, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public void func_73660_a() {
        if (this.canRun() && this.burnTime <= 0 && this.hasFuel()) {
            this.consumeFuel();
            this.sendUpdate(this.getActiveState(), true);
        }
        if (this.burnTime > 0) {
            --this.burnTime;
            this.energy.createEnergy(this.getEnergyCreatedPerTick());
        } else {
            this.sendUpdate(this.getInactiveState(), false);
        }
        super.func_73660_a();
    }

    protected boolean canRun() {
        return this.field_145850_b != null && this.redstoneMode.shouldRun(this.field_145850_b.func_175640_z(this.field_174879_c)) && this.getEnergyStored() < this.getMaxEnergyStored();
    }

    protected void sendUpdate(BlockState newState, boolean force) {
        if (this.field_145850_b == null) {
            return;
        }
        BlockState oldState = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (oldState != newState || force) {
            this.field_145850_b.func_180501_a(this.field_174879_c, newState, 3);
            this.field_145850_b.func_184138_a(this.field_174879_c, oldState, newState, 3);
        }
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        this.burnTime = tags.func_74762_e("BurnTime");
        this.totalBurnTime = tags.func_74762_e("TotalBurnTime");
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT tags) {
        tags.func_74768_a("BurnTime", this.burnTime);
        tags.func_74768_a("TotalBurnTime", this.totalBurnTime);
        return super.func_189515_b(tags);
    }

    @Override
    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        this.burnTime = tags.func_74762_e("BurnTime");
        this.totalBurnTime = tags.func_74762_e("TotalBurnTime");
    }

    @Override
    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        tags.func_74768_a("BurnTime", this.burnTime);
        tags.func_74768_a("TotalBurnTime", this.totalBurnTime);
        return tags;
    }
}

