/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.mixer;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.block.AbstractFluidMachineTileEntity;
import net.silentchaos512.mechanisms.block.mixer.MixerContainer;
import net.silentchaos512.mechanisms.crafting.recipe.MixingRecipe;
import net.silentchaos512.mechanisms.init.ModRecipes;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class MixerTileEntity
extends AbstractFluidMachineTileEntity<MixingRecipe> {
    public static final int FIELDS_COUNT = 17;
    public static final int TANK_CAPACITY = 4000;
    public static final int ENERGY_PER_TICK = 100;

    public MixerTileEntity() {
        super(ModTileEntities.mixer, 4, 5, 4000, MachineTier.STANDARD);
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tryFillTanks();
        this.tryFillFluidContainer();
        super.func_73660_a();
    }

    @Override
    protected void consumeIngredients(MixingRecipe recipe) {
    }

    private void tryFillTanks() {
        block3: {
            FluidStack fluidStack;
            ItemStack input;
            block2: {
                input = this.func_70301_a(0);
                if (input.func_190926_b()) {
                    return;
                }
                fluidStack = IFluidContainer.getBucketOrContainerFluid(input);
                int tankIndex = this.findTankWithFluid(fluidStack);
                if (tankIndex <= -1) break block2;
                if (!this.canAcceptFluidContainer(input, fluidStack, tankIndex)) break block3;
                this.fillTankWithContainer(input, fluidStack, (IFluidHandler)this.tanks[tankIndex]);
                break block3;
            }
            for (int i = 0; i < this.getInputTanks(); ++i) {
                if (!this.canAcceptFluidContainer(input, fluidStack, i)) continue;
                this.fillTankWithContainer(input, fluidStack, (IFluidHandler)this.tanks[i]);
                break;
            }
        }
    }

    private int findTankWithFluid(FluidStack fluidStack) {
        for (int i = 0; i < this.getInputTanks(); ++i) {
            FluidStack fluidInTank = this.getFluidInTank(i);
            if (fluidInTank.isEmpty() || fluidInTank.getFluid() != fluidStack.getFluid()) continue;
            return i;
        }
        return -1;
    }

    private void fillTankWithContainer(ItemStack input, FluidStack fluidStack, IFluidHandler tank) {
        tank.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
        ItemStack containerItem = input.getContainerItem();
        input.func_190918_g(1);
        ItemStack output = this.func_70301_a(1);
        if (output.func_190926_b()) {
            this.func_70299_a(1, containerItem);
        } else {
            output.func_190917_f(1);
        }
    }

    private boolean canAcceptFluidContainer(ItemStack input, FluidStack fluid, int tank) {
        ItemStack output = this.func_70301_a(1);
        return !(fluid.isEmpty() || !this.isFluidValid(tank, fluid) || this.tanks[tank].fill(fluid, IFluidHandler.FluidAction.SIMULATE) != fluid.getAmount() || !output.func_190926_b() && !InventoryUtils.canItemsStack(input.getContainerItem(), output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    private void tryFillFluidContainer() {
        ItemStack filled;
        ItemStack input = this.func_70301_a(2);
        if (input.func_190926_b()) {
            return;
        }
        FluidStack fluidInInput = IFluidContainer.getBucketOrContainerFluid(input);
        if (!fluidInInput.isEmpty()) {
            return;
        }
        FluidStack fluidInTank = this.getFluidInTank(4);
        if (fluidInTank.getAmount() >= 1000 && !(filled = IFluidContainer.fillBucketOrFluidContainer(input, fluidInTank)).func_190926_b() && InventoryUtils.mergeItem(this, filled, 3)) {
            this.tanks[4].drain(1000, IFluidHandler.FluidAction.EXECUTE);
            input.func_190918_g(1);
        }
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 100;
    }

    @Override
    protected int getInputTanks() {
        return 4;
    }

    @Override
    protected int getOutputTanks() {
        return 1;
    }

    @Override
    @Nullable
    public MixingRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.Types.MIXING, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(MixingRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<FluidStack> getFluidResults(MixingRecipe recipe) {
        return recipe.getFluidResults(this);
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && InventoryUtils.isFilledFluidContainer(stack) || index == 2 && InventoryUtils.isEmptyFluidContainer(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1 || index == 3;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "mixer", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new MixerContainer(id, player, this, this.fields);
    }
}

