/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.block.refinery;

import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.silentchaos512.mechanisms.api.IFluidContainer;
import net.silentchaos512.mechanisms.block.AbstractFluidMachineTileEntity;
import net.silentchaos512.mechanisms.block.refinery.RefineryContainer;
import net.silentchaos512.mechanisms.crafting.recipe.RefiningRecipe;
import net.silentchaos512.mechanisms.init.ModRecipes;
import net.silentchaos512.mechanisms.init.ModTileEntities;
import net.silentchaos512.mechanisms.util.InventoryUtils;
import net.silentchaos512.mechanisms.util.MachineTier;
import net.silentchaos512.mechanisms.util.TextUtil;

public class RefineryTileEntity
extends AbstractFluidMachineTileEntity<RefiningRecipe> {
    public static final int FIELDS_COUNT = 17;
    public static final int TANK_CAPACITY = 4000;
    public static final int ENERGY_PER_TICK = 100;

    public RefineryTileEntity() {
        super(ModTileEntities.refinery, 4, 5, 4000, MachineTier.STANDARD);
    }

    @Override
    @Nullable
    public RefiningRecipe getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return this.field_145850_b.func_199532_z().func_215371_a(ModRecipes.Types.REFINING, (IInventory)this, this.field_145850_b).orElse(null);
    }

    @Override
    protected int getProcessTime(RefiningRecipe recipe) {
        return recipe.getProcessTime();
    }

    @Override
    protected Collection<FluidStack> getFluidResults(RefiningRecipe recipe) {
        return recipe.getFluidResults(this);
    }

    @Override
    protected int getEnergyUsedPerTick() {
        return 100;
    }

    @Override
    protected int getInputTanks() {
        return 1;
    }

    @Override
    protected int getOutputTanks() {
        return 4;
    }

    @Override
    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.tryFillTank();
        this.tryFillFluidContainer();
        super.func_73660_a();
    }

    @Override
    protected void consumeIngredients(RefiningRecipe recipe) {
    }

    private void tryFillTank() {
        ItemStack input = this.func_70301_a(0);
        if (input.func_190926_b()) {
            return;
        }
        FluidStack fluidStack = IFluidContainer.getBucketOrContainerFluid(input);
        if (this.canAcceptFluidContainer(input, fluidStack)) {
            this.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
            ItemStack containerItem = input.getContainerItem();
            input.func_190918_g(1);
            ItemStack output = this.func_70301_a(1);
            if (output.func_190926_b()) {
                this.func_70299_a(1, containerItem);
            } else {
                output.func_190917_f(1);
            }
        }
    }

    private boolean canAcceptFluidContainer(ItemStack input, FluidStack fluid) {
        ItemStack output = this.func_70301_a(1);
        return !(fluid.isEmpty() || !this.isFluidValid(0, fluid) || this.fill(fluid, IFluidHandler.FluidAction.SIMULATE) != 1000 || !output.func_190926_b() && !InventoryUtils.canItemsStack(input.getContainerItem(), output) || !output.func_190926_b() && output.func_190916_E() >= output.func_77976_d());
    }

    private void tryFillFluidContainer() {
        ItemStack input = this.func_70301_a(2);
        if (input.func_190926_b()) {
            return;
        }
        FluidStack fluidInInput = IFluidContainer.getBucketOrContainerFluid(input);
        if (!fluidInInput.isEmpty()) {
            return;
        }
        for (int i = 1; i < 5; ++i) {
            ItemStack filled;
            FluidStack fluidInTank = this.getFluidInTank(i);
            if (fluidInTank.getAmount() < 1000 || (filled = IFluidContainer.fillBucketOrFluidContainer(input, fluidInTank)).func_190926_b() || !InventoryUtils.mergeItem(this, filled, 3)) continue;
            this.tanks[i].drain(1000, IFluidHandler.FluidAction.EXECUTE);
            input.func_190918_g(1);
            return;
        }
    }

    public int[] func_180463_a(Direction side) {
        return new int[]{0, 1, 2, 3};
    }

    public boolean func_180462_a(int index, ItemStack stack, @Nullable Direction direction) {
        return index == 0 && InventoryUtils.isFilledFluidContainer(stack) || index == 2 && InventoryUtils.isEmptyFluidContainer(stack);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 1 || index == 3;
    }

    protected ITextComponent func_213907_g() {
        return TextUtil.translate("container", "refinery", new Object[0]);
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new RefineryContainer(id, player, this, this.fields);
    }
}

