/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.silentchaos512.lib.util.TextRenderUtils;
import net.silentchaos512.mechanisms.block.compressor.CompressorScreen;
import net.silentchaos512.mechanisms.crafting.recipe.DryingRecipe;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.util.Constants;
import net.silentchaos512.mechanisms.util.TextUtil;

public class DryingRecipeCategoryJei
implements IRecipeCategory<DryingRecipe> {
    private static final int GUI_START_X = 55;
    private static final int GUI_START_Y = 30;
    private static final int GUI_WIDTH = 82;
    private static final int GUI_HEIGHT = 26;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public DryingRecipeCategoryJei(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(CompressorScreen.TEXTURE, 55, 30, 82, 26);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack(ModBlocks.OAK_DRYING_RACK));
        this.arrow = guiHelper.drawableBuilder(CompressorScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.drying", new Object[0]).getString();
    }

    public ResourceLocation getUid() {
        return Constants.DRYING;
    }

    public Class<? extends DryingRecipe> getRecipeClass() {
        return DryingRecipe.class;
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(DryingRecipe recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(Collections.singletonList(recipe.getIngredient()));
        ingredients.setOutput(VanillaTypes.ITEM, (Object)recipe.func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, DryingRecipe recipe, IIngredients ingredients) {
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        itemStacks.init(0, true, 0, 4);
        itemStacks.init(1, false, 60, 4);
        itemStacks.set(0, new ArrayList<ItemStack>(Arrays.asList(recipe.getIngredient().func_193365_a())));
        itemStacks.set(1, recipe.func_77571_b());
    }

    public void draw(DryingRecipe recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 24, 5);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        IFormattableTextComponent text = TextUtil.translate("misc", "timeInSeconds", recipe.getProcessTime() / 20);
        TextRenderUtils.renderScaled((MatrixStack)matrixStack, (FontRenderer)font, (IReorderingProcessor)text.func_241878_f(), (int)24, (int)20, (float)0.67f, (int)0xFFFFFF, (boolean)true);
    }
}

