/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.data.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.lib.util.NameUtils;
import net.silentchaos512.mechanisms.init.Metals;
import net.silentchaos512.mechanisms.init.ModRecipes;

public class AlloySmeltingRecipeBuilder {
    private final Map<Ingredient, Integer> ingredients = new LinkedHashMap<Ingredient, Integer>();
    private final ItemStack result;
    private final int processTime;

    private AlloySmeltingRecipeBuilder(IItemProvider result, int count, int processTime) {
        this.result = new ItemStack(result, count);
        this.processTime = processTime;
    }

    public static AlloySmeltingRecipeBuilder builder(IItemProvider result, int count, int processTime) {
        return new AlloySmeltingRecipeBuilder(result, count, processTime);
    }

    public static AlloySmeltingRecipeBuilder builder(Metals result, int count, int processTime) {
        return AlloySmeltingRecipeBuilder.builder((IItemProvider)result.getIngot().get(), count, processTime);
    }

    public AlloySmeltingRecipeBuilder ingredient(Ingredient ingredient, int count) {
        this.ingredients.put(ingredient, count);
        return this;
    }

    public AlloySmeltingRecipeBuilder ingredient(IItemProvider item, int count) {
        return this.ingredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{item}), count);
    }

    public AlloySmeltingRecipeBuilder ingredient(ITag<Item> tag, int count) {
        return this.ingredient(Ingredient.func_199805_a(tag), count);
    }

    public AlloySmeltingRecipeBuilder ingredient(Metals metal, int count) {
        return this.ingredient(metal.getSmeltables(), count);
    }

    public void build(Consumer<IFinishedRecipe> consumer) {
        ResourceLocation resultId = NameUtils.fromItem((ItemStack)this.result);
        ResourceLocation id = new ResourceLocation("minecraft".equals(resultId.func_110624_b()) ? "silents_mechanisms" : resultId.func_110624_b(), "alloy_smelting/" + resultId.func_110623_a());
        this.build(consumer, id);
    }

    public void build(Consumer<IFinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this));
    }

    public class Result
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final AlloySmeltingRecipeBuilder builder;

        public Result(ResourceLocation id, AlloySmeltingRecipeBuilder builder) {
            this.id = id;
            this.builder = builder;
        }

        public void func_218610_a(JsonObject json) {
            json.addProperty("process_time", (Number)this.builder.processTime);
            JsonArray ingredients = new JsonArray();
            this.builder.ingredients.forEach((ingredient, count) -> ingredients.add(this.serializeIngredient((Ingredient)ingredient, (int)count)));
            json.add("ingredients", (JsonElement)ingredients);
            JsonObject result = new JsonObject();
            result.addProperty("item", NameUtils.fromItem((ItemStack)this.builder.result).toString());
            if (this.builder.result.func_190916_E() > 1) {
                result.addProperty("count", (Number)this.builder.result.func_190916_E());
            }
            json.add("result", (JsonElement)result);
        }

        private JsonElement serializeIngredient(Ingredient ingredient, int count) {
            JsonObject json = new JsonObject();
            json.add("value", ingredient.func_200304_c());
            json.addProperty("count", (Number)count);
            return json;
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return (IRecipeSerializer)ModRecipes.ALLOY_SMELTING.get();
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

