/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.init;

import java.util.Locale;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.OreBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.ToolType;
import net.silentchaos512.lib.registry.BlockRegistryObject;
import net.silentchaos512.lib.registry.ItemRegistryObject;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.block.MetalBlock;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.init.Registration;

public enum Metals {
    REDSTONE_ALLOY(Metals.builderAlloy("redstone_alloy")),
    REFINED_IRON(Metals.builder("refined_iron").ingot()),
    COMPRESSED_IRON(Metals.builder("compressed_iron").ingot()),
    IRON(Metals.builder("iron").chunks().dust().ingotTagOnly().nuggetTagOnly()),
    GOLD(Metals.builder("gold").chunks().dust().ingotTagOnly().nuggetTagOnly()),
    COPPER(Metals.builderBaseWithOre("copper", Ores.COPPER)),
    TIN(Metals.builderBaseWithOre("tin", Ores.TIN)),
    SILVER(Metals.builderBaseWithOre("silver", Ores.SILVER)),
    LEAD(Metals.builderBaseWithOre("lead", Ores.LEAD)),
    NICKEL(Metals.builderBaseWithOre("nickel", Ores.NICKEL)),
    PLATINUM(Metals.builderBaseWithOre("platinum", Ores.PLATINUM)),
    ZINC(Metals.builderBaseWithOre("zinc", Ores.ZINC)),
    BISMUTH(Metals.builderBaseWithOre("bismuth", Ores.BISMUTH)),
    ALUMINUM(Metals.builderBaseWithOre("aluminum", Ores.BAUXITE), "bauxite"),
    URANIUM(Metals.builderBaseWithOre("uranium", Ores.URANIUM)),
    BRONZE(Metals.builderAlloy("bronze")),
    BRASS(Metals.builderAlloy("brass")),
    INVAR(Metals.builderAlloy("invar")),
    ELECTRUM(Metals.builderAlloy("electrum")),
    STEEL(Metals.builderAlloy("steel")),
    BISMUTH_BRASS(Metals.builderAlloy("bismuth_brass")),
    ALUMINUM_STEEL(Metals.builderAlloy("aluminum_steel")),
    BISMUTH_STEEL(Metals.builderAlloy("bismuth_steel")),
    SIGNALUM(Metals.builderAlloy("signalum")),
    LUMIUM(Metals.builderAlloy("lumium")),
    ENDERIUM(Metals.builderAlloy("enderium"));

    private final String oreName;
    private BlockRegistryObject<Block> ore;
    private BlockRegistryObject<Block> storageBlock;
    private ItemRegistryObject<Item> chunks;
    private ItemRegistryObject<Item> dust;
    private ItemRegistryObject<Item> ingot;
    private ItemRegistryObject<Item> nugget;
    private final Supplier<Block> oreSupplier;
    private final Supplier<Block> storageBlockSupplier;
    private final Supplier<Item> chunksSupplier;
    private final Supplier<Item> dustSupplier;
    private final Supplier<Item> ingotSupplier;
    private final Supplier<Item> nuggetSupplier;
    private final ITag.INamedTag<Block> storageBlockTag;
    private final ITag.INamedTag<Block> oreTag;
    private final ITag.INamedTag<Item> storageBlockItemTag;
    private final ITag.INamedTag<Item> oreItemTag;
    private final ITag.INamedTag<Item> chunksTag;
    private final ITag.INamedTag<Item> dustTag;
    private final ITag.INamedTag<Item> ingotTag;
    private final ITag.INamedTag<Item> nuggetTag;

    private Metals(Builder builder) {
        this(builder, builder.name);
    }

    private Metals(Builder builder, String oreName) {
        if (!builder.name.equals(this.getName())) {
            throw new IllegalArgumentException("Builder name is incorrect, should be " + this.getName());
        }
        this.oreName = oreName;
        this.storageBlockSupplier = builder.storageBlock;
        this.oreSupplier = builder.ore;
        this.chunksSupplier = builder.chunks;
        this.dustSupplier = builder.dust;
        this.ingotSupplier = builder.ingot;
        this.nuggetSupplier = builder.nugget;
        this.oreTag = builder.oreTag;
        this.storageBlockTag = builder.storageBlockTag;
        this.oreItemTag = this.oreTag != null ? Builder.itemTag(this.oreTag.func_230234_a_()) : null;
        this.storageBlockItemTag = this.storageBlockTag != null ? Builder.itemTag(this.storageBlockTag.func_230234_a_()) : null;
        this.chunksTag = builder.chunksTag;
        this.dustTag = builder.dustTag;
        this.ingotTag = builder.ingotTag;
        this.nuggetTag = builder.nuggetTag;
    }

    public String getName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public Optional<Block> getOre() {
        return this.ore != null ? Optional.of(this.ore.get()) : Optional.empty();
    }

    public Optional<Block> getStorageBlock() {
        return this.storageBlock != null ? Optional.of(this.storageBlock.get()) : Optional.empty();
    }

    public Optional<Item> getChunks() {
        return this.chunks != null ? Optional.of(this.chunks.get()) : Optional.empty();
    }

    public Optional<Item> getDust() {
        return this.dust != null ? Optional.of(this.dust.get()) : Optional.empty();
    }

    public Optional<Item> getIngot() {
        return this.ingot != null ? Optional.of(this.ingot.get()) : Optional.empty();
    }

    public Optional<Item> getNugget() {
        return this.nugget != null ? Optional.of(this.nugget.get()) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Block>> getOreTag() {
        return this.oreTag != null ? Optional.of(this.oreTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Block>> getStorageBlockTag() {
        return this.storageBlockTag != null ? Optional.of(this.storageBlockTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getOreItemTag() {
        return this.oreItemTag != null ? Optional.of(this.oreItemTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getStorageBlockItemTag() {
        return this.storageBlockItemTag != null ? Optional.of(this.storageBlockItemTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getChunksTag() {
        return this.chunksTag != null ? Optional.of(this.chunksTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getDustTag() {
        return this.dustTag != null ? Optional.of(this.dustTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getIngotTag() {
        return this.ingotTag != null ? Optional.of(this.ingotTag) : Optional.empty();
    }

    public Optional<ITag.INamedTag<Item>> getNuggetTag() {
        return this.nuggetTag != null ? Optional.of(this.nuggetTag) : Optional.empty();
    }

    public Ingredient getSmeltables() {
        return this.getSmeltables(true);
    }

    public Ingredient getSmeltables(boolean includeIngot) {
        Stream.Builder builder = Stream.builder();
        if (includeIngot) {
            this.getIngotTag().ifPresent(builder::add);
        }
        this.getChunksTag().ifPresent(builder::add);
        this.getDustTag().ifPresent(builder::add);
        return Ingredient.func_209357_a(builder.build().map(Ingredient.TagList::new));
    }

    public static void registerBlocks() {
        String name;
        for (Metals metal : Metals.values()) {
            if (metal.oreSupplier == null) continue;
            name = metal.oreName + "_ore";
            metal.ore = new BlockRegistryObject(Registration.BLOCKS.register(name, metal.oreSupplier));
            Registration.ITEMS.register(name, () -> new BlockItem((Block)metal.ore.get(), new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP)));
        }
        for (Metals metal : Metals.values()) {
            if (metal.storageBlockSupplier == null) continue;
            name = metal.getName() + "_block";
            metal.storageBlock = new BlockRegistryObject(Registration.BLOCKS.register(name, metal.storageBlockSupplier));
            Registration.ITEMS.register(name, () -> new BlockItem((Block)metal.storageBlock.get(), new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP)));
        }
    }

    public static void registerItems() {
        for (Metals metal : Metals.values()) {
            if (metal.chunksSupplier != null) {
                metal.chunks = new ItemRegistryObject(Registration.ITEMS.register(metal.oreName + "_chunks", metal.chunksSupplier));
            }
            if (metal.dustSupplier != null) {
                metal.dust = new ItemRegistryObject(Registration.ITEMS.register(metal.getName() + "_dust", metal.dustSupplier));
            }
            if (metal.ingotSupplier != null) {
                metal.ingot = new ItemRegistryObject(Registration.ITEMS.register(metal.getName() + "_ingot", metal.ingotSupplier));
            }
            if (metal.nuggetSupplier == null) continue;
            metal.nugget = new ItemRegistryObject(Registration.ITEMS.register(metal.getName() + "_nugget", metal.nuggetSupplier));
        }
    }

    private static Builder builder(String name) {
        return new Builder(name);
    }

    private static Builder builderBaseWithOre(String name, Ores ore) {
        return Metals.builder(name).storageBlock().ore(ore).chunks().dust().ingot().nugget();
    }

    private static Builder builderAlloy(String name) {
        return Metals.builder(name).storageBlock().dust().ingot().nugget();
    }

    private static class Builder {
        final String name;
        Supplier<Block> ore;
        Supplier<Block> storageBlock;
        Supplier<Item> chunks;
        Supplier<Item> dust;
        Supplier<Item> ingot;
        Supplier<Item> nugget;
        ITag.INamedTag<Block> oreTag;
        ITag.INamedTag<Block> storageBlockTag;
        ITag.INamedTag<Item> chunksTag;
        ITag.INamedTag<Item> dustTag;
        ITag.INamedTag<Item> ingotTag;
        ITag.INamedTag<Item> nuggetTag;

        Builder(String name) {
            this.name = name;
        }

        Builder ore(Ores ore) {
            this.ore = () -> new OreBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151576_e).func_235861_h_().harvestTool(ToolType.PICKAXE).harvestLevel(ore.getHarvestLevel()).func_200948_a((float)ore.getHardness(), 3.0f).func_200947_a(SoundType.field_185851_d));
            this.oreTag = Builder.blockTag("ores/" + this.name);
            return this;
        }

        Builder storageBlock() {
            this.storageBlock = MetalBlock::new;
            this.storageBlockTag = Builder.blockTag("storage_blocks/" + this.name);
            return this;
        }

        Builder chunks() {
            this.chunks = () -> new Item(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
            this.chunksTag = Builder.itemTag(SilentMechanisms.getId("chunks/" + this.name));
            return this;
        }

        Builder dust() {
            this.dust = () -> new Item(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
            this.dustTag = Builder.itemTag("dusts/" + this.name);
            return this;
        }

        Builder ingot() {
            this.ingot = () -> new Item(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
            this.ingotTag = Builder.itemTag("ingots/" + this.name);
            return this;
        }

        Builder ingotTagOnly() {
            this.ingotTag = Builder.itemTag("ingots/" + this.name);
            return this;
        }

        Builder nugget() {
            this.nugget = () -> new Item(new Item.Properties().func_200916_a(SilentMechanisms.ITEM_GROUP));
            this.nuggetTag = Builder.itemTag("nuggets/" + this.name);
            return this;
        }

        Builder nuggetTagOnly() {
            this.nuggetTag = Builder.itemTag("nuggets/" + this.name);
            return this;
        }

        private static ITag.INamedTag<Block> blockTag(String path) {
            return BlockTags.func_199894_a((String)new ResourceLocation("forge", path).toString());
        }

        private static ITag.INamedTag<Item> itemTag(String path) {
            return ItemTags.func_199901_a((String)new ResourceLocation("forge", path).toString());
        }

        private static ITag.INamedTag<Item> itemTag(ResourceLocation tag) {
            return ItemTags.func_199901_a((String)tag.toString());
        }
    }
}

