/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.mechanisms.world;

import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.WorldGenRegistries;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.BlockStateFeatureConfig;
import net.minecraft.world.gen.feature.ConfiguredFeature;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.IFeatureConfig;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraft.world.gen.placement.ChanceConfig;
import net.minecraft.world.gen.placement.IPlacementConfig;
import net.minecraft.world.gen.placement.Placement;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.lib.util.Lazy;
import net.silentchaos512.mechanisms.SilentMechanisms;
import net.silentchaos512.mechanisms.config.Config;
import net.silentchaos512.mechanisms.init.ModBlocks;
import net.silentchaos512.mechanisms.init.Ores;
import net.silentchaos512.mechanisms.world.feature.OilLakesFeature;

@Mod.EventBusSubscriber(modid="silents_mechanisms")
public final class SMWorldFeatures {
    private static final Lazy<ConfiguredFeature<?, ?>> OIL_LAKES_STANDARD = Lazy.of(() -> SMWorldFeatures.createOilLakeFeature(1.0f));
    private static final Lazy<ConfiguredFeature<?, ?>> OIL_LAKES_COMMON = Lazy.of(() -> SMWorldFeatures.createOilLakeFeature(0.67f));

    private SMWorldFeatures() {
    }

    @SubscribeEvent
    public static void registerFeatures(RegistryEvent.Register<Feature<?>> event) {
        event.getRegistry().register(OilLakesFeature.INSTANCE.setRegistryName(SilentMechanisms.getId("oil_lakes")));
        for (Ores ore : Ores.values()) {
            ore.getConfig().ifPresent(config -> SMWorldFeatures.registerConfiguredFeature(ore.getName() + "_vein", ore.getConfiguredFeature()));
        }
        SMWorldFeatures.registerConfiguredFeature("oil_lakes_standard", (ConfiguredFeature)OIL_LAKES_STANDARD.get());
        SMWorldFeatures.registerConfiguredFeature("oil_lakes_common", (ConfiguredFeature)OIL_LAKES_COMMON.get());
    }

    private static void registerConfiguredFeature(String name, ConfiguredFeature<?, ?> configuredFeature) {
        SilentMechanisms.LOGGER.debug("register configured feature '{}'", (Object)name);
        Registry.func_218322_a((Registry)WorldGenRegistries.field_243653_e, (ResourceLocation)SilentMechanisms.getId(name), configuredFeature);
    }

    @SubscribeEvent
    public static void addFeaturesToBiomes(BiomeLoadingEvent biome) {
        if (biome.getCategory() != Biome.Category.NETHER && biome.getCategory() != Biome.Category.THEEND) {
            for (Ores ore : Ores.values()) {
                ore.getConfig().ifPresent(config -> {
                    if (config.isEnabled()) {
                        SMWorldFeatures.addOre(biome, ore);
                    }
                });
            }
            SMWorldFeatures.addOilLakes(biome);
        }
    }

    private static ConfiguredFeature<?, ?> createOilLakeFeature(float multi) {
        int config = (Integer)Config.worldGenOilLakeChance.get();
        if (config > 0) {
            return OilLakesFeature.INSTANCE.func_225566_b_((IFeatureConfig)new BlockStateFeatureConfig(ModBlocks.OIL.asBlockState())).func_227228_a_(Placement.field_215006_E.func_227446_a_((IPlacementConfig)new ChanceConfig((int)(multi * (float)config))));
        }
        return Feature.field_227245_q_.func_225566_b_((IFeatureConfig)new NoFeatureConfig());
    }

    private static void addOilLakes(BiomeLoadingEvent biome) {
        int config = (Integer)Config.worldGenOilLakeChance.get();
        if (config > 0 && biome.getName() != null) {
            ConfiguredFeature feature = biome.getName().equals((Object)Biomes.field_76769_d.getRegistryName()) ? (ConfiguredFeature)OIL_LAKES_COMMON.get() : (ConfiguredFeature)OIL_LAKES_STANDARD.get();
            biome.getGeneration().func_242513_a(GenerationStage.Decoration.LOCAL_MODIFICATIONS, feature);
        }
    }

    private static void addOre(BiomeLoadingEvent biome, Ores ore) {
        biome.getGeneration().func_242513_a(GenerationStage.Decoration.UNDERGROUND_ORES, ore.getConfiguredFeature());
    }
}

