/*
 * Decompiled with CFR 0.152.
 */
package net.johnvictorfs.simple_utilities.hud;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.johnvictorfs.simple_utilities.helpers.Colors;
import net.johnvictorfs.simple_utilities.mixin.GameClientMixin;
import net.minecraft.class_1074;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_918;

@Environment(value=EnvType.CLIENT)
public class GameInfoHud {
    private final class_310 client;
    private final class_327 fontRenderer;
    private class_746 player;
    private class_4587 matrixStack;
    private static class_304 toggleKeybinding;
    private final class_918 itemRenderer;
    private boolean toggledOn = true;

    public GameInfoHud(class_310 client) {
        this.client = client;
        this.fontRenderer = client.field_1772;
        this.itemRenderer = client.method_1480();
        this.itemRenderer.field_4730 -= 500.0f;
        for (class_304 keyBinding : client.field_1690.field_1839) {
            if (!keyBinding.method_1431().equals("key.simple_utilities.toggle_hud")) continue;
            toggleKeybinding = keyBinding;
        }
        ClientTickEvents.END_CLIENT_TICK.register(_client -> {
            if (toggleKeybinding.method_1436()) {
                assert (client.field_1724 != null);
                String chatMessage = "key.simple_utilities.toggle_hud.chat_message.on";
                if (this.toggledOn) {
                    chatMessage = "key.simple_utilities.toggle_hud.chat_message.off";
                }
                client.field_1724.method_7353((class_2561)new class_2588(chatMessage), true);
                this.toggledOn = !this.toggledOn;
            }
        });
    }

    public void draw(class_4587 matrixStack) {
        if (!this.toggledOn) {
            return;
        }
        this.player = this.client.field_1724;
        this.matrixStack = matrixStack;
        this.drawInfos();
        this.client.method_16011().method_15407();
    }

    private void drawInfos() {
        List<String> gameInfo = this.getGameInfo();
        this.drawEquipementInfo();
        Objects.requireNonNull(this.fontRenderer);
        int lineHeight = 9 + 2;
        int top = 0;
        int left = 4;
        for (String line : gameInfo) {
            this.fontRenderer.method_1729(this.matrixStack, line, (float)left, (float)(top + 4), 0xE0E0E0);
            top += lineHeight;
        }
        if (this.player.method_5624()) {
            String sprintingText = "Sprinting";
            int maxLineHeight = Math.max(10, this.fontRenderer.method_1727("Sprinting"));
            maxLineHeight = (int)(Math.ceil((double)maxLineHeight / 5.0 + 0.5) * 5.0);
            int scaleHeight = this.client.method_22683().method_4502();
            int sprintingTop = scaleHeight - maxLineHeight;
            this.fontRenderer.method_1729(this.matrixStack, "Sprinting", 2.0f, (float)(sprintingTop + 20), 0xE0E0E0);
        }
    }

    private static String capitalize(String str) {
        if (str == null) {
            return null;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    private static String getOffset(class_2350 facing) {
        String offset = "";
        if (facing.method_10148() > 0) {
            offset = offset + "+X";
        } else if (facing.method_10148() < 0) {
            offset = offset + "-X";
        }
        if (facing.method_10165() > 0) {
            offset = offset + " +Z";
        } else if (facing.method_10165() < 0) {
            offset = offset + " -Z";
        }
        return offset.trim();
    }

    private String zeroPadding(int number) {
        return number >= 10 ? Integer.toString(number) : String.format("0%s", number);
    }

    private String secondsToString(int pTime) {
        int min = pTime / 60;
        int sec = pTime - min * 60;
        String strMin = this.zeroPadding(min);
        String strSec = this.zeroPadding(sec);
        return String.format("%s:%s", strMin, strSec);
    }

    private void drawStatusEffectInfo() {
        if (this.client.field_1724 != null) {
            Map effects = this.client.field_1724.method_6088();
            for (Map.Entry effect : effects.entrySet()) {
                String effectName = class_1074.method_4662((String)((class_1291)effect.getKey()).method_5567(), (Object[])new Object[0]);
                String duration = this.secondsToString(((class_1293)effect.getValue()).method_5584() / 20);
                int color = ((class_1291)effect.getKey()).method_5556();
                this.fontRenderer.method_1729(this.matrixStack, effectName + " " + duration, 40.0f, 200.0f, color);
            }
        }
    }

    private void drawEquipementInfo() {
        ArrayList<class_1799> equippedItems = new ArrayList<class_1799>();
        class_1661 inventory = this.player.field_7514;
        int maxLineHeight = Math.max(10, this.fontRenderer.method_1727(""));
        class_1799 mainHandItem = inventory.method_7391();
        maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)mainHandItem.method_7922(), (Object[])new Object[0])));
        equippedItems.add(mainHandItem);
        for (class_1799 secondHandItem : inventory.field_7544) {
            maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)secondHandItem.method_7922(), (Object[])new Object[0])));
            equippedItems.add(secondHandItem);
        }
        for (class_1799 armourItem : this.player.field_7514.field_7548) {
            maxLineHeight = Math.max(maxLineHeight, this.fontRenderer.method_1727(class_1074.method_4662((String)armourItem.method_7922(), (Object[])new Object[0])));
            equippedItems.add(armourItem);
        }
        maxLineHeight = (int)(Math.ceil((double)maxLineHeight / 5.0 + 0.5) * 5.0);
        int itemTop = this.client.method_22683().method_4502() - maxLineHeight;
        Objects.requireNonNull(this.fontRenderer);
        int lineHeight = 9 + 6;
        for (class_1799 equippedItem : Lists.reverse(equippedItems)) {
            if (equippedItem.method_7909().equals(class_2246.field_10124.method_8389())) continue;
            this.itemRenderer.method_4023(equippedItem, 2, itemTop - 68);
            if (equippedItem.method_7936() != 0) {
                int currentDurability = equippedItem.method_7936() - equippedItem.method_7919();
                String itemDurability = currentDurability + "/" + equippedItem.method_7936();
                int color = 0xE0E0E0;
                if (currentDurability < equippedItem.method_7936()) {
                    color = Colors.lightGreen;
                }
                if ((double)currentDurability <= (double)equippedItem.method_7936() / 1.5) {
                    color = Colors.lightYellow;
                }
                if ((double)currentDurability <= (double)equippedItem.method_7936() / 2.5) {
                    color = Colors.lightOrange;
                }
                if (currentDurability <= equippedItem.method_7936() / 4) {
                    color = Colors.lightRed;
                }
                this.fontRenderer.method_1729(this.matrixStack, itemDurability, 22.0f, (float)(itemTop - 64), color);
            } else {
                int inventoryCount = inventory.method_18861(equippedItem.method_7909());
                int count = equippedItem.method_7947();
                if (inventoryCount > 1) {
                    String itemCount = count + " (" + inventoryCount + ")";
                    this.fontRenderer.method_1729(this.matrixStack, itemCount, 22.0f, (float)(itemTop - 64), 0xE0E0E0);
                }
            }
            itemTop += lineHeight;
        }
    }

    private static String parseTime(long time) {
        long hours = (time / 1000L + 6L) % 24L;
        long minutes = time % 1000L * 60L / 1000L;
        String ampm = "AM";
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "PM";
        }
        if (hours >= 12L) {
            hours -= 12L;
            ampm = "AM";
        }
        if (hours == 0L) {
            hours = 12L;
        }
        String mm = "0" + minutes;
        mm = mm.substring(mm.length() - 2);
        return hours + ":" + mm + " " + ampm;
    }

    private List<String> getGameInfo() {
        ArrayList<String> gameInfo = new ArrayList<String>();
        class_2350 facing = this.player.method_5735();
        String coordsFormat = "%.0f, %.0f, %.0f %s";
        String direction = "(" + GameInfoHud.capitalize(facing.method_15434()) + " " + GameInfoHud.getOffset(facing) + ")";
        gameInfo.add(String.format(coordsFormat, this.player.method_23317(), this.player.method_23318(), this.player.method_23321(), direction));
        gameInfo.add(String.format("%d fps", ((GameClientMixin)class_310.method_1551()).getCurrentFps()));
        if (this.client.field_1687 != null) {
            gameInfo.add(GameInfoHud.capitalize(this.client.field_1687.method_23753(this.player.method_24515()).method_8688().method_8749()) + " Biome");
            gameInfo.add(GameInfoHud.parseTime(this.client.field_1687.method_8532()));
        }
        return gameInfo;
    }
}

