/*
 * Decompiled with CFR 0.152.
 */
package foxahead.simpleworldtimer.gui;

import foxahead.simpleworldtimer.ConfigSWT;
import foxahead.simpleworldtimer.client.handlers.KeyHandlerSWT;
import foxahead.simpleworldtimer.gui.GuiSWTCheckbox;
import foxahead.simpleworldtimer.gui.GuiSWTSlider;
import foxahead.simpleworldtimer.gui.GuiSWTSmallButton;
import foxahead.simpleworldtimer.gui.ISWTSliderObserver;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiSWTOptions
extends Screen
implements ISWTSliderObserver {
    private static final int COLOR1 = -1;
    private static final int COLOR2 = -2039584;
    private GuiSWTCheckbox checkBoxEnable;
    private GuiSWTCheckbox checkBoxAutoHide;
    private GuiSWTSmallButton smallButtonPreset;
    private Button buttonCustom;
    private GuiSWTSmallButton smallButtonClockType;
    private Button buttonStart;
    private Button buttonPause;
    private Button buttonStop;
    private TextFieldWidget startDateTextField;
    private TextFieldWidget patternTextField1;
    private TextFieldWidget patternTextField2;
    private Button buttonSwap;
    private boolean initialized = false;
    private int xCoord = 0;
    private int yCoord = 0;
    private int yStep = 24;
    private int focus = -1;

    public GuiSWTOptions() {
        super((ITextComponent)new TranslationTextComponent("options.title", new Object[0]));
    }

    public void tick() {
        if (!this.initialized) {
            return;
        }
        this.startDateTextField.func_146178_a();
        this.patternTextField1.func_146178_a();
        this.patternTextField2.func_146178_a();
    }

    public void init() {
        this.minecraft.field_195559_v.func_197967_a(true);
        this.xCoord = this.width / 2 - 100;
        this.yCoord = (this.height - this.yStep * 9) / 2;
        this.checkBoxEnable = (GuiSWTCheckbox)this.addButton((Widget)new GuiSWTCheckbox(this.xCoord, this.yCoord + this.yStep, 100, 20, I18n.func_135052_a((String)"options.swt.enable", (Object[])new Object[0]), ConfigSWT.getEnable(), onPress11 -> this.actionPerformed(11)));
        this.checkBoxAutoHide = (GuiSWTCheckbox)this.addButton((Widget)new GuiSWTCheckbox(this.xCoord + 100, this.yCoord + this.yStep, 100, 20, I18n.func_135052_a((String)"options.swt.autoHide", (Object[])new Object[0]), ConfigSWT.getAutoHide(), onPress12 -> this.actionPerformed(12)));
        this.addButton(new GuiSWTSlider(2, this.xCoord, this.yCoord + this.yStep * 2, "X: ", ConfigSWT.getxPosition(), this));
        this.addButton(new GuiSWTSlider(3, this.xCoord, this.yCoord + this.yStep * 3, "Y: ", ConfigSWT.getyPosition(), this));
        this.smallButtonPreset = (GuiSWTSmallButton)this.addButton((Widget)new GuiSWTSmallButton(this.xCoord, this.yCoord + this.yStep * 4, 176, 20, I18n.func_135052_a((String)"options.swt.preset", (Object[])new Object[0]), ConfigSWT.getPresetList(), ConfigSWT.getPreset(), onPress21 -> this.actionPerformed(21)));
        this.buttonCustom = (Button)this.addButton((Widget)new Button(this.xCoord + 180, this.yCoord + this.yStep * 4, 20, 20, "C", onPress4 -> this.actionPerformed(4)));
        this.smallButtonClockType = (GuiSWTSmallButton)this.addButton((Widget)new GuiSWTSmallButton(this.xCoord, this.yCoord + this.yStep * 5, 75, 20, "", ConfigSWT.getClockTypeList(), ConfigSWT.getClockType(), onPress22 -> this.actionPerformed(22)));
        this.startDateTextField = new TextFieldWidget(this.font, this.xCoord + 150, this.yCoord + this.yStep * 5, 50, 20, "");
        this.startDateTextField.func_212954_a(onText1 -> this.onTextField(1));
        this.patternTextField1 = new TextFieldWidget(this.font, this.xCoord, this.yCoord + this.yStep * 6, 176, 20, "");
        this.patternTextField1.func_212954_a(onText1 -> this.onTextField(2));
        this.patternTextField2 = new TextFieldWidget(this.font, this.xCoord, this.yCoord + this.yStep * 7, 176, 20, "");
        this.patternTextField2.func_212954_a(onText1 -> this.onTextField(3));
        this.children.add(this.startDateTextField);
        this.children.add(this.patternTextField1);
        this.children.add(this.patternTextField2);
        this.buttonSwap = (Button)this.addButton((Widget)new Button(this.xCoord + 180, (int)((float)this.yCoord + (float)this.yStep * 6.5f), 20, 20, ")", onPress5 -> this.actionPerformed(5)));
        this.addButton((Widget)new Button(this.xCoord, this.yCoord + this.yStep * 8, 200, 20, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0]), onPress0 -> this.actionPerformed(0)));
        this.buttonStart = (Button)this.addButton((Widget)new Button(this.xCoord + 102, this.yCoord + this.yStep * 5, 30, 20, ">", onPress6 -> this.actionPerformed(6)));
        this.buttonPause = (Button)this.addButton((Widget)new Button(this.xCoord + 136, this.yCoord + this.yStep * 5, 30, 20, "||", onPress7 -> this.actionPerformed(7)));
        this.buttonStop = (Button)this.addButton((Widget)new Button(this.xCoord + 170, this.yCoord + this.yStep * 5, 30, 20, "[]", onPress8 -> this.actionPerformed(8)));
        this.updateButtons();
        this.initialized = true;
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public void actionPerformed(int parGuiButtonId) {
        String pattern1 = "";
        String pattern2 = "";
        if (parGuiButtonId == 0) {
            this.closeMe();
        }
        if (parGuiButtonId == 4) {
            pattern1 = ConfigSWT.getPattern1();
            pattern2 = ConfigSWT.getPattern2();
            int preset = ConfigSWT.getPreset();
            ConfigSWT.setPreset(4);
            ConfigSWT.setClockType(preset);
            ConfigSWT.setPattern1(pattern1);
            ConfigSWT.setPattern2(pattern2);
        }
        if (parGuiButtonId == 5) {
            pattern1 = ConfigSWT.getPattern1();
            ConfigSWT.setPattern1(ConfigSWT.getPattern2());
            ConfigSWT.setPattern2(pattern1);
        }
        if (parGuiButtonId >= 6 || parGuiButtonId <= 8) {
            long start = ConfigSWT.getStopWatchStart();
            long stop = ConfigSWT.getStopWatchStop();
            long now = this.minecraft.field_71441_e.func_82737_E();
            switch (parGuiButtonId) {
                case 6: {
                    if (start > stop) break;
                    ConfigSWT.setStopWatchStart(start + now - stop);
                    ConfigSWT.setStopWatchStop(0L);
                    break;
                }
                case 7: {
                    if (stop != 0L) break;
                    ConfigSWT.setStopWatchStop(now);
                    break;
                }
                case 8: {
                    ConfigSWT.setStopWatchStart(now);
                    ConfigSWT.setStopWatchStop(now);
                }
            }
        }
        if (parGuiButtonId == 11) {
            ConfigSWT.setEnable(this.checkBoxEnable.State);
        }
        if (parGuiButtonId == 12) {
            ConfigSWT.setAutoHide(this.checkBoxAutoHide.State);
        }
        if (parGuiButtonId == 21) {
            ConfigSWT.setPreset(this.smallButtonPreset.getIndex());
        }
        if (parGuiButtonId == 22) {
            ConfigSWT.setClockType(this.smallButtonClockType.getIndex());
        }
        this.updateButtons();
    }

    private void onTextField(int id) {
        switch (id) {
            case 1: {
                try {
                    ConfigSWT.setStartYear(Integer.parseInt(this.startDateTextField.func_146179_b()));
                }
                catch (Exception e) {
                    ConfigSWT.setStartYear(0);
                }
                break;
            }
            case 2: {
                ConfigSWT.setPattern1(this.patternTextField1.func_146179_b());
                break;
            }
            case 3: {
                ConfigSWT.setPattern2(this.patternTextField2.func_146179_b());
            }
        }
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        if (super.keyPressed(par1, par2, par3)) {
            return true;
        }
        if (par1 == 256) {
            this.closeMe();
        }
        if (par1 == KeyHandlerSWT.keySWT.getKey().func_197937_c() && !this.isTyping()) {
            this.closeMe();
        }
        return true;
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        this.startDateTextField.mouseClicked(par1, par2, par3);
        this.patternTextField1.mouseClicked(par1, par2, par3);
        this.patternTextField2.mouseClicked(par1, par2, par3);
        return super.mouseClicked(par1, par2, par3);
    }

    @Override
    public void sliderValueChanged(GuiSWTSlider slider) {
        if (slider.id == 2) {
            ConfigSWT.setxPosition(slider.sliderValue);
        }
        if (slider.id == 3) {
            ConfigSWT.setyPosition(slider.sliderValue);
        }
    }

    public void render(int par1, int par2, float par3) {
        if (!this.initialized) {
            return;
        }
        this.renderBackground();
        this.drawCenteredString(this.font, I18n.func_135052_a((String)"options.swt.title", (Object[])new Object[0]), this.width / 2, this.yCoord, -1);
        if (this.smallButtonClockType.getIndex() == 1) {
            this.drawCenteredString(this.font, I18n.func_135052_a((String)"options.swt.startYear", (Object[])new Object[0]), this.xCoord + 120, this.yCoord + this.yStep * 5 + 6, -2039584);
        }
        this.startDateTextField.render(par1, par2, par3);
        this.patternTextField1.render(par1, par2, par3);
        this.patternTextField2.render(par1, par2, par3);
        super.render(par1, par2, par3);
    }

    public void closeMe() {
        this.minecraft.func_147108_a((Screen)null);
    }

    public boolean isTyping() {
        return this.patternTextField1.isFocused() || this.patternTextField2.isFocused();
    }

    private void updateButtons() {
        this.smallButtonPreset.setIndex(ConfigSWT.getPreset());
        this.smallButtonClockType.setIndex(ConfigSWT.getClockType());
        switch (this.smallButtonPreset.getIndex()) {
            case 4: {
                this.smallButtonClockType.active = true;
                this.patternTextField1.func_146184_c(true);
                this.patternTextField2.func_146184_c(true);
                this.smallButtonClockType.setIndex(ConfigSWT.getClockType());
                this.buttonCustom.active = false;
                this.buttonSwap.active = true;
                break;
            }
            default: {
                this.smallButtonClockType.active = false;
                this.patternTextField1.func_146184_c(false);
                this.patternTextField2.func_146184_c(false);
                this.smallButtonClockType.setIndex(this.smallButtonPreset.getIndex());
                this.buttonCustom.active = true;
                this.buttonSwap.active = false;
            }
        }
        switch (this.smallButtonClockType.getIndex()) {
            case 1: {
                this.startDateTextField.func_146184_c(true);
                this.startDateTextField.func_146189_e(true);
                break;
            }
            default: {
                this.startDateTextField.func_146184_c(false);
                this.startDateTextField.func_146189_e(false);
            }
        }
        this.buttonStop.visible = this.smallButtonClockType.getIndex() == 2;
        this.buttonPause.visible = this.buttonStop.visible;
        this.buttonStart.visible = this.buttonStop.visible;
        this.startDateTextField.func_146180_a(String.valueOf(ConfigSWT.getStartYear()));
        this.patternTextField1.func_146180_a(ConfigSWT.getPattern1());
        this.patternTextField2.func_146180_a(ConfigSWT.getPattern2());
    }

    public boolean doesGuiPauseGame() {
        return true;
    }
}

