/*
 * Decompiled with CFR 0.152.
 */
package foxahead.simpleworldtimer;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigSWT {
    public static ConfigSWT instance = new ConfigSWT();
    public static final ForgeConfigSpec CONFIG_SPEC;
    public static final ConfigSWTValues CONFIG_VALUES;
    public static final String NEW_LINE;
    public static final int PRESET_TOTAL_WORLD = 0;
    public static final int PRESET_MINECRAFT = 1;
    public static final int PRESET_STOPWATCH = 2;
    public static final int PRESET_SYSTEM = 3;
    public static final int PRESET_CUSTOM = 4;
    public static final int CLOCK_TYPE_TOTAL_WORLD = 0;
    public static final int CLOCK_TYPE_MINECRAFT = 1;
    public static final int CLOCK_TYPE_STOPWATCH = 2;
    public static final int CLOCK_TYPE_SYSTEM = 3;
    public static String[][] patterns;

    private ConfigSWT() {
    }

    public static List<String> getPresetList() {
        return Arrays.asList(I18n.func_135052_a((String)"options.swt.preset0", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.preset1", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.preset2", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.preset3", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.preset4", (Object[])new Object[0]));
    }

    public static List<String> getClockTypeList() {
        return Arrays.asList(I18n.func_135052_a((String)"options.swt.clockType0", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.clockType1", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.clockType2", (Object[])new Object[0]), I18n.func_135052_a((String)"options.swt.clockType3", (Object[])new Object[0]));
    }

    public static boolean getEnable() {
        return (Boolean)ConfigSWTValues.enable.get();
    }

    public static void setEnable(boolean enable) {
        ConfigSWTValues.enable.set((Object)enable);
    }

    public static boolean getAutoHide() {
        return (Boolean)ConfigSWTValues.autoHide.get();
    }

    public static void setAutoHide(boolean autoHide) {
        ConfigSWTValues.autoHide.set((Object)autoHide);
    }

    public static int getxPosition() {
        return (Integer)ConfigSWTValues.xPosition.get();
    }

    public static void setxPosition(int xPosition) {
        ConfigSWTValues.xPosition.set((Object)MathHelper.func_76125_a((int)xPosition, (int)0, (int)100));
    }

    public static int getyPosition() {
        return (Integer)ConfigSWTValues.yPosition.get();
    }

    public static void setyPosition(int yPosition) {
        ConfigSWTValues.yPosition.set((Object)MathHelper.func_76125_a((int)yPosition, (int)0, (int)100));
    }

    public static int getPreset() {
        return (Integer)ConfigSWTValues.preset.get();
    }

    public static void setPreset(int preset) {
        ConfigSWTValues.preset.set((Object)MathHelper.func_76125_a((int)preset, (int)0, (int)(ConfigSWT.getPresetList().size() - 1)));
    }

    public static int getClockType() {
        if (ConfigSWT.getPreset() == 4) {
            return (Integer)ConfigSWTValues.clockType.get();
        }
        return ConfigSWT.getPreset();
    }

    public static void setClockType(int clockType) {
        if (ConfigSWT.getPreset() == 4) {
            ConfigSWTValues.clockType.set((Object)MathHelper.func_76125_a((int)clockType, (int)0, (int)(ConfigSWT.getClockTypeList().size() - 1)));
        }
    }

    public static int getStartYear() {
        return (Integer)ConfigSWTValues.startYear.get();
    }

    public static void setStartYear(int startYear) {
        ConfigSWTValues.startYear.set((Object)startYear);
    }

    public static String getPattern1() {
        if (ConfigSWT.getPreset() == 4) {
            return (String)ConfigSWTValues.pattern1.get();
        }
        return patterns[ConfigSWT.getPreset()][0];
    }

    public static void setPattern1(String pattern1) {
        if (ConfigSWT.getPreset() == 4) {
            ConfigSWTValues.pattern1.set((Object)pattern1.trim());
        }
    }

    public static String getPattern2() {
        if (ConfigSWT.getPreset() == 4) {
            return (String)ConfigSWTValues.pattern2.get();
        }
        return patterns[ConfigSWT.getPreset()][1];
    }

    public static void setPattern2(String pattern2) {
        if (ConfigSWT.getPreset() == 4) {
            ConfigSWTValues.pattern2.set((Object)pattern2.trim());
        }
    }

    public static long getStopWatchStart() {
        return (Long)ConfigSWTValues.stopWatchStart.get();
    }

    public static void setStopWatchStart(long stopWatchStart) {
        ConfigSWTValues.stopWatchStart.set((Object)stopWatchStart);
    }

    public static long getStopWatchStop() {
        return (Long)ConfigSWTValues.stopWatchStop.get();
    }

    public static void setStopWatchStop(long stopWatchStop) {
        ConfigSWTValues.stopWatchStop.set((Object)stopWatchStop);
    }

    @SubscribeEvent
    public void onLoad(ModConfig.Loading configEvent) {
        this.pushChanges();
    }

    @SubscribeEvent
    public void onFileChange(ModConfig.Reloading configEvent) {
        ((CommentedFileConfig)configEvent.getConfig().getConfigData()).load();
        this.pushChanges();
    }

    private void pushChanges() {
        ConfigSWTValues.enable.get();
        ConfigSWTValues.autoHide.get();
        ConfigSWTValues.xPosition.get();
        ConfigSWTValues.yPosition.get();
        ConfigSWTValues.preset.get();
        ConfigSWTValues.clockType.get();
        ConfigSWTValues.startYear.get();
        ConfigSWTValues.pattern1.get();
        ConfigSWTValues.pattern2.get();
        ConfigSWTValues.stopWatchStart.get();
        ConfigSWTValues.stopWatchStop.get();
    }

    static {
        patterns = new String[][]{{"'[&dd ]'HH:mm:ss", ""}, {"dd.MM.yyyy", "'Day &d' HH:mm"}, {"'[&dd ]'HH:mm:ss.SSS", "'Ticks &w'"}, {"dd.MM.yyyy", "HH:mm:ss"}};
        NEW_LINE = System.getProperty("line.separator");
        Pair specPair = new ForgeConfigSpec.Builder().configure(ConfigSWTValues::new);
        CONFIG_SPEC = (ForgeConfigSpec)specPair.getRight();
        CONFIG_VALUES = (ConfigSWTValues)specPair.getLeft();
    }

    public static class ConfigSWTValues {
        private static ForgeConfigSpec.BooleanValue enable;
        private static ForgeConfigSpec.BooleanValue autoHide;
        private static ForgeConfigSpec.IntValue xPosition;
        private static ForgeConfigSpec.IntValue yPosition;
        private static ForgeConfigSpec.IntValue preset;
        private static ForgeConfigSpec.IntValue clockType;
        private static ForgeConfigSpec.IntValue startYear;
        private static ForgeConfigSpec.ConfigValue<String> pattern1;
        private static ForgeConfigSpec.ConfigValue<String> pattern2;
        private static ForgeConfigSpec.LongValue stopWatchStart;
        private static ForgeConfigSpec.LongValue stopWatchStop;

        ConfigSWTValues(ForgeConfigSpec.Builder builder) {
            builder.comment("General settings").push("general");
            enable = builder.comment("Enable Simple World Timer").define("enable", true);
            autoHide = builder.comment("Auto hide timer on various screens like inventory, chat, debug, no-GUI mode (F1), main menu etc.").define("autoHide", true);
            xPosition = builder.comment("Relative horizontal position in %. From 0% to 100%.").defineInRange("xPosition", 0, 0, 100);
            yPosition = builder.comment("Relative vertical position in %. From 0% to 100%.").defineInRange("yPosition", 10, 0, 100);
            preset = builder.comment("Timer preset:" + NEW_LINE + "0 - Total World Time" + NEW_LINE + "1 - Minecraft Time" + NEW_LINE + "2 - Stopwatch" + NEW_LINE + "3 - System Time" + NEW_LINE + "4 - Custom configuration").defineInRange("preset", 0, 0, 4);
            clockType = builder.comment("Source of data for timer:" + NEW_LINE + "0 - Total time of world being ticked provided by getTotalWorldTime() function" + NEW_LINE + "1 - in-game time provided by getWorldTime() function. Used for day/night cycle." + NEW_LINE + "    Can be changed by 'time set' command. 0 ticks equals 6:00 AM. 24000 ticks for one Minecraft day." + NEW_LINE + "2 - Manual start/stop" + NEW_LINE + "3 - System clock;").defineInRange("clockType", 0, 0, 3);
            startYear = builder.comment("Starting year for Minecraft time. To make sense of its calendar representation.").defineInRange("startYear", 1, Integer.MIN_VALUE, Integer.MAX_VALUE);
            pattern1 = builder.comment("Custom pattern for line 1" + NEW_LINE + "Pattern letters of standard java.text.SimpleDateFormat class used." + NEW_LINE + "Additional syntax take effect after:" + NEW_LINE + "&d - total days" + NEW_LINE + "&w - total ticks" + NEW_LINE + "&t - current two-sign ticks in current second (00-19)" + NEW_LINE + "If you additionally put it in square brackets then everything within will output only if included values are non-zero" + NEW_LINE + "Those should be quoted using single quotes (') to avoid initial interpretation by SimpleDateFormat").define("pattern1", (Object)"");
            pattern2 = builder.comment("Custom pattern for line 2").define("pattern2", (Object)"");
            stopWatchStart = builder.comment("When was Stopwatch started").defineInRange("stopWatchStart", 0L, Long.MIN_VALUE, Long.MAX_VALUE);
            stopWatchStop = builder.comment("When was Stopwatch stopped").defineInRange("stopWatchStop", 0L, Long.MIN_VALUE, Long.MAX_VALUE);
            builder.pop();
        }
    }
}

