/*
 * Decompiled with CFR 0.152.
 */
package foxahead.simpleworldtimer;

import com.mojang.blaze3d.systems.RenderSystem;
import foxahead.simpleworldtimer.ConfigSWT;
import foxahead.simpleworldtimer.Formatter;
import foxahead.simpleworldtimer.gui.GuiSWTOptions;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.minecraft.client.Minecraft;

public class Timer {
    private static final int UPDATE_INTERVAL = 10;
    private static final long TICKS_AFTER_EPOCH = 1242715392000L;
    private static final int WHITE_COLOR = -1;
    private static final int GRAY_COLOR = -2039584;
    private static final TimeZone TZ_UTC = TimeZone.getTimeZone("UTC");
    private long counter = 1000000L;
    private int startYear = 1000000;
    private long startTicks = 0L;
    private Minecraft mc = Minecraft.func_71410_x();
    private String language = "";
    private int clockType = -1;
    private SimpleDateFormat sdf1 = new SimpleDateFormat();
    private SimpleDateFormat sdf2 = new SimpleDateFormat();
    private String pattern1 = "";
    private String pattern2 = "";
    private boolean needsPostFormat1 = true;
    private boolean needsPostFormat2 = true;
    private String outText1 = "";
    private String outText2 = "";

    public void drawTick() {
        long ticks = 0L;
        int sWidth = 0;
        int sHeight = 0;
        int x = 0;
        int y = 0;
        int textW = 0;
        int xPosition = 0;
        int yPosition = 0;
        int lines = 0;
        int color = -1;
        if (this.mc.field_71441_e == null) {
            return;
        }
        if (this.mc.field_71466_p == null) {
            return;
        }
        if (!ConfigSWT.getEnable()) {
            return;
        }
        if (ConfigSWT.getAutoHide() && !(this.mc.field_71462_r instanceof GuiSWTOptions) && (this.mc.field_71474_y.field_74330_P || this.mc.field_71474_y.field_74319_N || !this.mc.func_195544_aj())) {
            return;
        }
        ++this.counter;
        this.outText1 = "";
        this.outText2 = "";
        try {
            this.updateCache();
            sWidth = this.mc.func_228018_at_().func_198107_o();
            sHeight = this.mc.func_228018_at_().func_198087_p();
            switch (this.clockType) {
                case 0: {
                    ticks = this.mc.field_71441_e.func_82737_E();
                    this.formatOutTexts(ticks, this.convertTicksToDate(ticks - 1242715392000L));
                    break;
                }
                case 2: {
                    ticks = this.mc.field_71441_e.func_82737_E();
                    if (ConfigSWT.getStopWatchStart() > ConfigSWT.getStopWatchStop()) {
                        ticks -= ConfigSWT.getStopWatchStart();
                    } else {
                        if (ticks / 10L % 2L == 0L) {
                            color = -2039584;
                        }
                        if ((ticks = ConfigSWT.getStopWatchStop() - ConfigSWT.getStopWatchStart()) == 0L) {
                            color = -1;
                        }
                    }
                    this.formatOutTexts(ticks, this.convertTicksToDate(ticks - 1242715392000L));
                    break;
                }
                case 1: {
                    ticks = this.mc.field_71441_e.func_72820_D();
                    this.formatOutTexts(ticks, this.convertTicksToDate((ticks + 6000L) * 72L - 1242715392000L + this.startTicks));
                    break;
                }
                case 3: {
                    this.formatOutTexts(0L, Calendar.getInstance().getTime());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!this.outText1.isEmpty()) {
            ++lines;
        }
        if (!this.outText2.isEmpty()) {
            ++lines;
        }
        xPosition = ConfigSWT.getxPosition();
        yPosition = ConfigSWT.getyPosition();
        if (this.mc.field_71474_y.field_74319_N) {
            // empty if block
        }
        RenderSystem.disableLighting();
        this.mc.field_71466_p.getClass();
        y = (sHeight - 9 * lines - 1) * yPosition / 100 + 1;
        if (!this.outText1.isEmpty()) {
            textW = this.mc.field_71466_p.func_78256_a(this.outText1);
            x = (sWidth - textW - 1) * xPosition / 100 + 1;
            this.mc.field_71466_p.func_175063_a(this.outText1, (float)x, (float)y, color);
            this.mc.field_71466_p.getClass();
            y += 9;
        }
        if (!this.outText2.isEmpty()) {
            textW = this.mc.field_71466_p.func_78256_a(this.outText2);
            x = (sWidth - textW - 1) * xPosition / 100 + 1;
            this.mc.field_71466_p.func_175063_a(this.outText2, (float)x, (float)y, color);
        }
    }

    private void formatOutTexts(long ticks, Date date) {
        if (!this.pattern1.isEmpty()) {
            this.outText1 = this.sdf1.format(date);
            if (this.needsPostFormat1) {
                this.outText1 = this.postFormatOutText(ticks, date, this.outText1);
            }
        }
        if (!this.pattern2.isEmpty()) {
            this.outText2 = this.sdf2.format(date);
            if (this.needsPostFormat2) {
                this.outText2 = this.postFormatOutText(ticks, date, this.outText2);
            }
        }
    }

    private String postFormatOutText(long parTicks, Date date, String outText) {
        long days = 0L;
        long totalDaysOfYear = 0L;
        long totalYears = 0L;
        switch (this.clockType) {
            case 0: {
                days = parTicks / 1728000L;
                break;
            }
            case 1: {
                days = (parTicks + 30000L) / 24000L;
                Calendar cal = Calendar.getInstance(TZ_UTC);
                cal.setTime(date);
                cal.add(10, -6);
                totalYears = (cal.get(0) == 1 ? cal.get(1) : -cal.get(1)) - (this.startYear == 0 ? 1 : this.startYear);
                cal.add(1, (int)(-totalYears));
                totalDaysOfYear = cal.get(6) - 1;
            }
        }
        return Formatter.format(outText, parTicks, parTicks % 20L, days, totalDaysOfYear, totalYears);
    }

    private Date convertTicksToDate(long parTicks) {
        return new Date(parTicks * 50L);
    }

    private void updateCache() {
        this.updateStartYear();
        if (this.updateLanguage() | this.updateClockType() | this.updatePatterns()) {
            this.createNewSDF();
        }
    }

    private void createNewSDF() {
        try {
            this.sdf1 = new SimpleDateFormat("", new Locale(this.language.substring(0, 2), this.language.substring(3, 5)));
            this.sdf2 = new SimpleDateFormat("", new Locale(this.language.substring(0, 2), this.language.substring(3, 5)));
        }
        catch (Exception e) {
            this.sdf1 = new SimpleDateFormat("");
            this.sdf2 = new SimpleDateFormat("");
        }
        switch (this.clockType) {
            case 0: 
            case 1: 
            case 2: {
                this.sdf1.setTimeZone(TZ_UTC);
                this.sdf2.setTimeZone(TZ_UTC);
            }
        }
        this.sdf1.applyPattern(this.pattern1);
        this.sdf2.applyPattern(this.pattern2);
    }

    private boolean updateLanguage() {
        String newValue;
        if (this.counter % 10L == 0L && !this.language.equals(newValue = this.mc.func_135016_M().func_135041_c().getCode())) {
            this.language = newValue;
            return true;
        }
        return false;
    }

    private boolean updateClockType() {
        int newValue;
        if (this.counter % 10L == 0L && this.clockType != (newValue = ConfigSWT.getClockType())) {
            this.clockType = newValue;
            return true;
        }
        return false;
    }

    private boolean updateStartYear() {
        int newValue;
        if (this.counter % 10L == 0L && this.startYear != (newValue = ConfigSWT.getStartYear())) {
            this.startYear = newValue;
            if (newValue <= 0) {
                ++newValue;
            }
            try {
                Calendar cal = Calendar.getInstance(TZ_UTC);
                cal.set(newValue, 0, 1, 0, 0, 0);
                cal.set(14, 0);
                this.startTicks = cal.getTimeInMillis() / 50L + 1242715392000L;
            }
            catch (Exception e) {
                this.startTicks = 0L;
            }
            return true;
        }
        return false;
    }

    private boolean updatePatterns() {
        boolean changed = false;
        if (this.counter % 10L == 0L) {
            String newValue1 = ConfigSWT.getPattern1();
            String newValue2 = ConfigSWT.getPattern2();
            if (!this.pattern1.equals(newValue1)) {
                this.pattern1 = newValue1;
                this.needsPostFormat1 = this.pattern1.contains("&");
                changed = true;
            }
            if (!this.pattern2.equals(newValue2)) {
                this.pattern2 = newValue2;
                this.needsPostFormat2 = this.pattern2.contains("&");
                changed = true;
            }
        }
        return changed;
    }
}

