/*
 * Decompiled with CFR 0.152.
 */
package at.nuxnux.skinnedlanterns.blocks;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkinnedLanternBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final BooleanProperty HANGING = BlockStateProperties.f_61435_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.m_49796_((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape SHAPE_HANGING = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Block.m_49796_((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public SkinnedLanternBlock(boolean soul) {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60999_().m_60978_(3.5f).m_60918_(SoundType.f_56762_).m_60953_(p_235447_0_ -> {
            if (soul) {
                return 10;
            }
            return 15;
        }).m_60955_());
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)HANGING, (Comparable)Boolean.FALSE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape m_5940_(BlockState p_153474_, BlockGetter p_153475_, BlockPos p_153476_, CollisionContext p_153477_) {
        return (Boolean)p_153474_.m_61143_((Property)HANGING) != false ? SHAPE_HANGING : SHAPE;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        for (Direction direction : context.m_6232_()) {
            BlockState blockstate;
            if (direction.m_122434_() != Direction.Axis.Y || !(blockstate = (BlockState)this.m_49966_().m_61124_((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).m_60710_((LevelReader)context.m_43725_(), context.m_8083_())) continue;
            return (BlockState)((BlockState)blockstate.m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        }
        return null;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> p_153490_) {
        p_153490_.m_61104_(new Property[]{HANGING, WATERLOGGED, FACING});
    }

    public boolean m_7898_(BlockState p_153479_, LevelReader p_153480_, BlockPos p_153481_) {
        Direction direction = SkinnedLanternBlock.getConnectedDirection(p_153479_).m_122424_();
        return Block.m_49863_((LevelReader)p_153480_, (BlockPos)p_153481_.m_142300_(direction), (Direction)direction.m_122424_());
    }

    protected static Direction getConnectedDirection(BlockState p_153496_) {
        return (Boolean)p_153496_.m_61143_((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public PushReaction m_5537_(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    public BlockState m_7417_(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        if (((Boolean)p_153483_.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            p_153486_.m_186469_(p_153487_, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)p_153486_));
        }
        return SkinnedLanternBlock.getConnectedDirection(p_153483_).m_122424_() == p_153484_ && !p_153483_.m_60710_((LevelReader)p_153486_, p_153487_) ? Blocks.f_50016_.m_49966_() : super.m_7417_(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    public FluidState m_5888_(BlockState p_153492_) {
        return (Boolean)p_153492_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_153492_);
    }

    public boolean m_7357_(BlockState p_153469_, BlockGetter p_153470_, BlockPos p_153471_, PathComputationType p_153472_) {
        return false;
    }
}

