/*
 * Decompiled with CFR 0.152.
 */
package at.nuxnux.skinnedlanterns.config;

import at.nuxnux.skinnedlanterns.config.Config;
import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;

public class EnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = new ResourceLocation("skinnedlanterns", "enabled");
    private final String name;

    public EnabledCondition(String name) {
        this.name = name;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        ForgeConfigSpec.BooleanValue enabled = (ForgeConfigSpec.BooleanValue)Config.CONFIG.getValues().get("lanterns." + this.name);
        return (Boolean)enabled.get();
    }

    public static class Serializer
    implements IConditionSerializer<EnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, EnabledCondition value) {
        }

        public EnabledCondition read(JsonObject json) {
            return new EnabledCondition(json.get("name").getAsString());
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

