/*
 * Decompiled with CFR 0.152.
 */
package at.nuxnux.skinnedlanterns.blocks;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SkinnedLanternBlock
extends HorizontalDirectionalBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<SkinnedLanternBlock> CODEC = SkinnedLanternBlock.simpleCodec(SkinnedLanternBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty HANGING = BlockStateProperties.HANGING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0), (VoxelShape)Block.box((double)6.0, (double)8.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0));
    private static final VoxelShape SHAPE_HANGING = Shapes.or((VoxelShape)Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), (VoxelShape)Block.box((double)6.0, (double)9.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0));

    public SkinnedLanternBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)HANGING, (Comparable)Boolean.FALSE)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState p_153474_, BlockGetter p_153475_, BlockPos p_153476_, CollisionContext p_153477_) {
        return (Boolean)p_153474_.getValue((Property)HANGING) != false ? SHAPE_HANGING : SHAPE;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        for (Direction direction : context.getNearestLookingDirections()) {
            BlockState blockstate;
            if (direction.getAxis() != Direction.Axis.Y || !(blockstate = (BlockState)this.defaultBlockState().setValue((Property)HANGING, (Comparable)Boolean.valueOf(direction == Direction.UP))).canSurvive((LevelReader)context.getLevel(), context.getClickedPos())) continue;
            return (BlockState)((BlockState)blockstate.setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> p_153490_) {
        p_153490_.add(new Property[]{HANGING, WATERLOGGED, FACING});
    }

    public boolean canSurvive(BlockState p_153479_, LevelReader p_153480_, BlockPos p_153481_) {
        Direction direction = SkinnedLanternBlock.getConnectedDirection(p_153479_).getOpposite();
        return Block.canSupportCenter((LevelReader)p_153480_, (BlockPos)p_153481_.relative(direction), (Direction)direction.getOpposite());
    }

    protected static Direction getConnectedDirection(BlockState p_153496_) {
        return (Boolean)p_153496_.getValue((Property)HANGING) != false ? Direction.DOWN : Direction.UP;
    }

    public PushReaction getPistonPushReaction(BlockState p_153494_) {
        return PushReaction.DESTROY;
    }

    public BlockState updateShape(BlockState p_153483_, Direction p_153484_, BlockState p_153485_, LevelAccessor p_153486_, BlockPos p_153487_, BlockPos p_153488_) {
        if (((Boolean)p_153483_.getValue((Property)WATERLOGGED)).booleanValue()) {
            p_153486_.scheduleTick(p_153487_, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)p_153486_));
        }
        return SkinnedLanternBlock.getConnectedDirection(p_153483_).getOpposite() == p_153484_ && !p_153483_.canSurvive((LevelReader)p_153486_, p_153487_) ? Blocks.AIR.defaultBlockState() : super.updateShape(p_153483_, p_153484_, p_153485_, p_153486_, p_153487_, p_153488_);
    }

    public FluidState getFluidState(BlockState p_153492_) {
        return (Boolean)p_153492_.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(p_153492_);
    }

    protected boolean isPathfindable(BlockState p_153469_, PathComputationType p_153472_) {
        return false;
    }

    protected MapCodec<SkinnedLanternBlock> codec() {
        return CODEC;
    }
}

