/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.snowmercy.client;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import ladysnake.snowmercy.client.network.EntityDispatcher;
import ladysnake.snowmercy.client.render.entity.ChillSnugglesEntityRenderer;
import ladysnake.snowmercy.client.render.entity.IcicleEntityRenderer;
import ladysnake.snowmercy.client.render.entity.MortarsEntityRenderer;
import ladysnake.snowmercy.client.render.entity.RocketsEntityRenderer;
import ladysnake.snowmercy.client.render.entity.SawmanEntityRenderer;
import ladysnake.snowmercy.client.render.entity.SnowGolemHeadEntityRenderer;
import ladysnake.snowmercy.client.render.entity.SnugglesEntityRenderer;
import ladysnake.snowmercy.client.render.entity.model.MortarsEntityModel;
import ladysnake.snowmercy.client.render.entity.model.RocketsEntityModel;
import ladysnake.snowmercy.client.render.entity.model.SawmanEntityModel;
import ladysnake.snowmercy.client.render.entity.model.SnugglesEntityModel;
import ladysnake.snowmercy.common.SnowGolemEntityData;
import ladysnake.snowmercy.common.entity.WeaponizedSnowGolemEntity;
import ladysnake.snowmercy.common.init.EntityTypes;
import ladysnake.snowmercy.common.network.Packets;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.network.ClientSidePacketRegistry;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_583;

public class SnowMercyClient
implements ClientModInitializer {
    public static final Int2ObjectOpenHashMap<SnowGolemEntityData> GOLEM_MODELS_AND_TEXTURES = new Int2ObjectOpenHashMap();

    public void onInitializeClient() {
        SnowMercyClient.registerRenders();
    }

    public static void registerRenders() {
        ClientSidePacketRegistry.INSTANCE.register(Packets.SPAWN, EntityDispatcher::spawnFrom);
        EntityRendererRegistry.INSTANCE.register(EntityTypes.SNUGGLES, (manager, context) -> new SnugglesEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.CHILL_SNUGGLES, (manager, context) -> new ChillSnugglesEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.ROCKETS, (manager, context) -> new RocketsEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.MORTARS, (manager, context) -> new MortarsEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.SAWMAN, (manager, context) -> new SawmanEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.SNOW_GOLEM_HEAD, (manager, context) -> new SnowGolemHeadEntityRenderer(manager));
        EntityRendererRegistry.INSTANCE.register(EntityTypes.ICICLE, (manager, context) -> new IcicleEntityRenderer(manager));
        GOLEM_MODELS_AND_TEXTURES.put(0, (Object)new SnowGolemEntityData((class_1299<? extends WeaponizedSnowGolemEntity>)EntityTypes.SAWMAN, (class_583<? extends WeaponizedSnowGolemEntity>)new SawmanEntityModel(), new class_2960("snowmercy", "textures/entity/sawman.png")));
        GOLEM_MODELS_AND_TEXTURES.put(1, (Object)new SnowGolemEntityData((class_1299<? extends WeaponizedSnowGolemEntity>)EntityTypes.SNUGGLES, (class_583<? extends WeaponizedSnowGolemEntity>)new SnugglesEntityModel(), new class_2960("snowmercy", "textures/entity/snuggles.png")));
        GOLEM_MODELS_AND_TEXTURES.put(2, (Object)new SnowGolemEntityData((class_1299<? extends WeaponizedSnowGolemEntity>)EntityTypes.ROCKETS, (class_583<? extends WeaponizedSnowGolemEntity>)new RocketsEntityModel(), new class_2960("snowmercy", "textures/entity/rockets.png")));
        GOLEM_MODELS_AND_TEXTURES.put(3, (Object)new SnowGolemEntityData((class_1299<? extends WeaponizedSnowGolemEntity>)EntityTypes.MORTARS, (class_583<? extends WeaponizedSnowGolemEntity>)new MortarsEntityModel(), new class_2960("snowmercy", "textures/entity/mortars.png")));
        GOLEM_MODELS_AND_TEXTURES.put(4, (Object)new SnowGolemEntityData((class_1299<? extends WeaponizedSnowGolemEntity>)EntityTypes.CHILL_SNUGGLES, (class_583<? extends WeaponizedSnowGolemEntity>)new SnugglesEntityModel(), new class_2960("snowmercy", "textures/entity/chill_snuggles.png")));
    }
}

