/*
 * Decompiled with CFR 0.152.
 */
package bl4ckscor3.mod.snowundertrees;

import bl4ckscor3.mod.snowundertrees.Configuration;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.SnowyDirtBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.season.SeasonHooks;

public class SereneSeasonsHandler {
    public static void tryMeltSnowUnderTrees(TickEvent.WorldTickEvent event) {
        Season.SubSeason subSeason = SeasonHelper.getSeasonState((World)event.world).getSubSeason();
        Season season = subSeason.getSeason();
        if (season != Season.WINTER) {
            ServerWorld world = (ServerWorld)event.world;
            world.func_72863_F().field_217237_a.func_223491_f().forEach(chunkHolder -> {
                Optional optional = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (optional.isPresent()) {
                    int meltRandomness;
                    switch (subSeason) {
                        case EARLY_SPRING: {
                            meltRandomness = 16;
                            break;
                        }
                        case MID_SPRING: {
                            meltRandomness = 12;
                            break;
                        }
                        case LATE_SPRING: {
                            meltRandomness = 8;
                            break;
                        }
                        default: {
                            meltRandomness = 4;
                        }
                    }
                    if (world.field_73012_v.nextInt(meltRandomness) == 0) {
                        BlockPos pos;
                        BlockState state;
                        Chunk chunk = (Chunk)optional.get();
                        ChunkPos chunkPos = chunk.func_76632_l();
                        int chunkX = chunkPos.func_180334_c();
                        int chunkY = chunkPos.func_180333_d();
                        BlockPos randomPos = world.func_217383_a(chunkX, 0, chunkY, 15);
                        Biome biome = world.func_226691_t_(randomPos);
                        boolean biomeDisabled = ((List)Configuration.CONFIG.filteredBiomes.get()).contains(biome.getRegistryName().toString());
                        if (!biomeDisabled && world.func_180495_p(world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, randomPos).func_177977_b()).func_177230_c() instanceof LeavesBlock && (state = world.func_180495_p(pos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, randomPos))).func_177230_c() == Blocks.field_150433_aE && SeasonHooks.getBiomeTemperature((World)world, (Biome)biome, (BlockPos)pos) >= 0.15f) {
                            BlockPos downPos = pos.func_177977_b();
                            BlockState below = world.func_180495_p(downPos);
                            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
                            if (below.func_235901_b_((Property)SnowyDirtBlock.field_196382_a)) {
                                world.func_180501_a(downPos, (BlockState)below.func_206870_a((Property)SnowyDirtBlock.field_196382_a, (Comparable)Boolean.valueOf(false)), 2);
                            }
                        }
                    }
                }
            });
        }
    }
}

