/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky;

import de.dafuqs.starrysky.advancements.ProximityAdvancementCheckEvent;
import de.dafuqs.starrysky.commands.StarrySkyCommands;
import de.dafuqs.starrysky.configs.StarrySkyConfig;
import de.dafuqs.starrysky.dimension.DecoratorFeatures;
import de.dafuqs.starrysky.dimension.StarrySkyDimension;
import de.dafuqs.starrysky.mixin.EntityAccessor;
import java.util.Optional;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import me.shedaniel.cloth.api.common.events.v1.PlayerChangeWorldCallback;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2424;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2784;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4048;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_5459;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StarrySkyCommon
implements ModInitializer {
    public static final String MOD_ID = "starry_sky";
    public static StarrySkyConfig STARRY_SKY_CONFIG;
    public static final Logger LOGGER;
    public static class_3218 starryWorld;
    public static class_3218 starryWorldNether;
    public static class_3218 starryWorldEnd;
    private static final class_2338 END_SPAWN_BLOCK_POS;
    private static final class_2338 OVERWORLD_SPAWN_BLOCK_POS;

    public void onInitialize() {
        LOGGER.info("[StarrySky] Starting up...");
        AutoConfig.register(StarrySkyConfig.class, JanksonConfigSerializer::new);
        STARRY_SKY_CONFIG = (StarrySkyConfig)AutoConfig.getConfigHolder(StarrySkyConfig.class).getConfig();
        StarrySkyDimension.setupDimension();
        StarrySkyDimension.setupPortals();
        StarrySkyCommands.initialize();
        DecoratorFeatures.initialize();
        ServerWorldEvents.LOAD.register((server, world) -> {
            if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_WORLD_KEY)) {
                starryWorld = world;
            } else if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY)) {
                starryWorldNether = world;
            } else if (world.method_27983().equals(StarrySkyDimension.STARRY_SKY_END_WORLD_KEY)) {
                starryWorldEnd = world;
            }
        });
        ServerTickEvents.END_SERVER_TICK.register((Object)new ProximityAdvancementCheckEvent());
        PlayerChangeWorldCallback.EVENT.register((Object)new PlayerChangeWorldCallback(){

            public void onChangeWorld(class_3222 serverPlayerEntity, class_5321<class_1937> registryKey, class_5321<class_1937> registryKey1) {
            }
        });
        LOGGER.info("[StarrySky] Finished loading.");
    }

    public static boolean inStarryWorld(class_3222 serverPlayerEntity) {
        return serverPlayerEntity.method_5770().equals(starryWorld) || serverPlayerEntity.method_5770().equals(starryWorldNether) || serverPlayerEntity.method_5770().equals(starryWorldEnd);
    }

    public static class_5454 handleGetTeleportTarget(class_1297 entity, class_3218 destination) {
        boolean bl2;
        class_1297 thisEntity = entity;
        boolean bl = thisEntity.field_6002.method_27983() == StarrySkyDimension.STARRY_SKY_END_WORLD_KEY && destination.method_27983() == StarrySkyDimension.STARRY_SKY_WORLD_KEY;
        boolean bl3 = bl2 = destination.method_27983() == StarrySkyDimension.STARRY_SKY_END_WORLD_KEY;
        if (!bl && !bl2) {
            boolean bl32;
            boolean bl4 = bl32 = destination.method_27983() == StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY;
            if (thisEntity.field_6002.method_27983() != StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY && !bl32) {
                return null;
            }
            class_2784 worldBorder = destination.method_8621();
            double d = Math.max(-2.9999872E7, worldBorder.method_11976() + 16.0);
            double e = Math.max(-2.9999872E7, worldBorder.method_11958() + 16.0);
            double f = Math.min(2.9999872E7, worldBorder.method_11963() - 16.0);
            double g = Math.min(2.9999872E7, worldBorder.method_11977() - 16.0);
            double h = class_2874.method_31109((class_2874)thisEntity.field_6002.method_8597(), (class_2874)destination.method_8597());
            class_2338 blockPos3 = new class_2338(class_3532.method_15350((double)(thisEntity.method_23317() * h), (double)d, (double)f), thisEntity.method_23318(), class_3532.method_15350((double)(thisEntity.method_23321() * h), (double)e, (double)g));
            return StarrySkyCommon.doMethod_30330(destination, blockPos3, bl32).map(arg -> {
                class_243 vec3d2;
                class_2350.class_2351 axis2;
                class_2338 lastNetherPortalPosition = ((EntityAccessor)entity).getLastNetherPortalPosition();
                class_2680 blockState = thisEntity.field_6002.method_8320(lastNetherPortalPosition);
                if (blockState.method_28498((class_2769)class_2741.field_12529)) {
                    axis2 = (class_2350.class_2351)blockState.method_11654((class_2769)class_2741.field_12529);
                    class_5459.class_5460 lv = class_5459.method_30574((class_2338)lastNetherPortalPosition, (class_2350.class_2351)axis2, (int)21, (class_2350.class_2351)class_2350.class_2351.field_11052, (int)21, blockPos -> thisEntity.field_6002.method_8320(blockPos) == blockState);
                    vec3d2 = StarrySkyCommon.doMethod_30633(thisEntity, axis2, lv);
                } else {
                    axis2 = class_2350.class_2351.field_11048;
                    vec3d2 = new class_243(0.5, 0.0, 0.0);
                }
                return class_2424.method_30484((class_3218)destination, (class_5459.class_5460)arg, (class_2350.class_2351)axis2, (class_243)vec3d2, (class_4048)thisEntity.method_18377(thisEntity.method_18376()), (class_243)thisEntity.method_18798(), (float)thisEntity.field_6031, (float)thisEntity.field_5965);
            }).orElse(null);
        }
        class_2338 blockPos2 = bl2 ? END_SPAWN_BLOCK_POS : OVERWORLD_SPAWN_BLOCK_POS;
        return new class_5454(new class_243((double)blockPos2.method_10263() + 0.5, (double)blockPos2.method_10264(), (double)blockPos2.method_10260() + 0.5), thisEntity.method_18798(), thisEntity.field_6031, thisEntity.field_5965);
    }

    public static class_3218 doinjected(class_1297 thisEntity, class_3218 x) {
        if (thisEntity.method_5770().method_27983().equals(StarrySkyDimension.STARRY_SKY_WORLD_KEY)) {
            return starryWorldNether;
        }
        if (thisEntity.method_5770().method_27983().equals(StarrySkyDimension.STARRY_SKY_NETHER_WORLD_KEY)) {
            return starryWorld;
        }
        return x;
    }

    private static class_243 doMethod_30633(class_1297 thisEntity, class_2350.class_2351 axis, class_5459.class_5460 arg) {
        return class_2424.method_30494((class_5459.class_5460)arg, (class_2350.class_2351)axis, (class_243)thisEntity.method_19538(), (class_4048)thisEntity.method_18377(thisEntity.method_18376()));
    }

    private static Optional<class_5459.class_5460> doMethod_30330(class_3218 serverWorld, class_2338 blockPos, boolean bl) {
        return serverWorld.method_14173().method_30483(blockPos, bl);
    }

    static {
        LOGGER = LogManager.getLogger((String)MOD_ID);
        END_SPAWN_BLOCK_POS = new class_2338(10, 64, 0);
        OVERWORLD_SPAWN_BLOCK_POS = new class_2338(16, 80, 16);
    }
}

