/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky;

import de.dafuqs.starrysky.dimension.SystemGenerator;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_5321;

public class Support {
    public static SpheroidDistance getClosestSpheroidToPlayer(class_1657 serverPlayerEntity) {
        class_243 playerPos = serverPlayerEntity.method_19538();
        class_2338 playerPosBlock = new class_2338((int)playerPos.field_1352, (int)playerPos.field_1351, (int)playerPos.field_1350);
        List<Spheroid> localSystem = SystemGenerator.getSystemGeneratorOfWorld((class_5321<class_1937>)serverPlayerEntity.method_5770().method_27983()).getSystemAtChunkPos(playerPosBlock.method_10263() / 16, playerPosBlock.method_10260() / 16);
        Spheroid closestSpheroid = null;
        double currentMinDistance = Double.MAX_VALUE;
        for (Spheroid p : localSystem) {
            double currDist = playerPosBlock.method_10262((class_2382)p.getPosition());
            if (!(currDist < currentMinDistance)) continue;
            currentMinDistance = currDist;
            closestSpheroid = p;
        }
        return new SpheroidDistance(closestSpheroid, currentMinDistance);
    }

    public static <E> E getWeightedRandom(LinkedHashMap<E, Float> weights, Random random) {
        E result = null;
        double bestValue = Double.MAX_VALUE;
        for (E element : weights.keySet()) {
            double value = -Math.log(random.nextDouble()) / (double)weights.get(element).floatValue();
            if (!(value < bestValue)) continue;
            bestValue = value;
            result = element;
        }
        return result;
    }

    public static int getRandomBetween(Random random, int lowest, int highest) {
        return random.nextInt(highest - lowest + 1) + lowest;
    }

    public static double getDistance(double x1, double y1, double z1, double x2, double y2, double z2) {
        return Math.sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2) + (z1 - z2) * (z1 - z2));
    }

    public static double getDistance(class_2338 blockPos1, class_2338 blockpos2) {
        return Support.getDistance(blockPos1.method_10263(), blockPos1.method_10264(), blockPos1.method_10260(), blockpos2.method_10263(), blockpos2.method_10264(), blockpos2.method_10260());
    }

    public static boolean isBlockPosInChunkPos(class_1923 chunkPos, class_2338 blockPos) {
        return blockPos.method_10263() >= chunkPos.method_8326() && blockPos.method_10263() < chunkPos.method_8326() + 16 && blockPos.method_10260() >= chunkPos.method_8328() && blockPos.method_10260() < chunkPos.method_8328() + 16;
    }

    public static int getLowerGroundBlock(class_1936 world, class_2338 position, int minHeight) {
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        while (blockpos$Mutable.method_10264() > minHeight && world.method_22347((class_2338)blockpos$Mutable)) {
            blockpos$Mutable.method_10098(class_2350.field_11033);
        }
        return blockpos$Mutable.method_10264();
    }

    public static int getUpperGroundBlock(class_1936 world, class_2338 position, int minHeight) {
        class_2338.class_2339 blockpos$Mutable = new class_2338.class_2339(position.method_10263(), position.method_10264(), position.method_10260());
        while (blockpos$Mutable.method_10264() > minHeight) {
            if (!world.method_22347((class_2338)blockpos$Mutable)) {
                return blockpos$Mutable.method_10264();
            }
            blockpos$Mutable.method_10098(class_2350.field_11036);
        }
        return -1;
    }

    public static class SpheroidDistance {
        public Spheroid spheroid;
        public double squaredDistance;

        public SpheroidDistance(Spheroid spheroid, double squaredDistance) {
            this.spheroid = spheroid;
            this.squaredDistance = squaredDistance;
        }
    }
}

