/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.lists;

import de.dafuqs.starrysky.StarrySkyCommon;
import de.dafuqs.starrysky.spheroid.lists.SpheroidList;
import de.dafuqs.starrysky.spheroid.types.CoreSpheroidType;
import de.dafuqs.starrysky.spheroid.types.SpheroidType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.class_2680;
import org.apache.logging.log4j.Level;

public class DynamicOreSpheroids {
    private static final LinkedHashMap<String, OreSpheroidDefinition> dynamicOreSpheroidDefinitions = new LinkedHashMap<String, OreSpheroidDefinition>(){
        {
            this.put("antimony", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 8, 3, 4, 0.7f));
            this.put("bauxite", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 7, 3, 5, 1.0f));
            this.put("galena", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 7, 10, 4, 7, 2.5f));
            this.put("iridium", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 5, 6, 1, 2, 0.05f));
            this.put("lead", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 15, 4, 6, 2.0f));
            this.put("lignite_coal", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 14, 5, 8, 6.0f));
            this.put("nickel", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 7, 3, 4, 0.8f));
            this.put("copper", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 7, 10, 4, 7, 5.0f));
            this.put("nikolite", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 8, 3, 5, 2.0f));
            this.put("ruby", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 5, 7, 3, 4, 0.8f));
            this.put("salt", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 8, 3, 5, 0.8f));
            this.put("sapphire", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 5, 7, 3, 4, 0.8f));
            this.put("silver", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 10, 3, 6, 2.0f));
            this.put("tin", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 10, 5, 7, 4.0f));
            this.put("unobtainium", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 3, 4, 1, 1, 0.05f));
            this.put("adamantite", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 4, 6, 1, 2, 0.2f));
            this.put("mythril", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 4, 6, 1, 2, 0.2f));
            this.put("orichalcum", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 4, 6, 1, 2, 0.2f));
            this.put("aetherium", new OreSpheroidDefinition(SpheroidList.MAP_DUNGEON_STONES, 4, 7, 2, 3, 0.4f));
            this.put("platinum", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 8, 3, 5, 0.4f));
            this.put("kyber", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 12, 15, 7, 10, 0.4f));
            this.put("lutetium", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 9, 3, 5, 0.7f));
            this.put("banglum", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 9, 3, 6, 0.7f));
            this.put("carmot", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 5, 7, 2, 4, 0.9f));
            this.put("manganese", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 8, 10, 4, 6, 0.9f));
            this.put("quadrillum", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 12, 4, 7, 0.9f));
            this.put("zinc", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 8, 11, 5, 6, 1.5f));
            this.put("osmium", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 9, 13, 5, 8, 1.5f));
            this.put("vermiculite", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 7, 13, 4, 7, 2.0f));
            this.put("tantalite", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 13, 4, 8, 0.9f));
            this.put("runite", new OreSpheroidDefinition(SpheroidList.MAP_STONES, 6, 8, 2, 5, 1.4f));
            this.put("starrite", new OreSpheroidDefinition(SpheroidList.MAP_MOUNTAIN_STONES, 5, 7, 2, 5, 0.4f));
            this.put("aquarium", new OreSpheroidDefinition(SpheroidList.MAP_OCEAN_STONES, 6, 12, 4, 7, 0.4f));
            this.put("prometheum", new OreSpheroidDefinition(SpheroidList.MAP_JUNGLE_STONES, 6, 9, 4, 4, 0.4f));
            this.put("midas_gold", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 6, 13, 4, 7, 1.8f));
            this.put("truesilver", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 7, 9, 3, 5, 1.5f));
            this.put("stormyx", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 7, 10, 4, 7, 0.4f));
            this.put("ur", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_DUNGEON_STONES, 3, 4, 1, 1, 0.05f));
            this.put("cinnabar", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 6, 13, 3, 5, 1.0f));
            this.put("pyrite", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 6, 13, 3, 5, 1.0f));
            this.put("sphalerite", new OreSpheroidDefinition(SpheroidList.MAP_NETHER_STONES, 6, 13, 3, 5, 1.0f));
            this.put("peridot", new OreSpheroidDefinition(SpheroidList.MAP_END_STONES, 6, 13, 3, 5, 1.0f));
            this.put("sheldonite", new OreSpheroidDefinition(SpheroidList.MAP_END_STONES, 6, 13, 3, 5, 1.0f));
            this.put("sodalite", new OreSpheroidDefinition(SpheroidList.MAP_END_STONES, 6, 13, 3, 5, 1.0f));
            this.put("tungsten", new OreSpheroidDefinition(SpheroidList.MAP_END_STONES, 6, 13, 3, 5, 1.0f));
        }
    };

    public static LinkedHashMap<SpheroidType, Float> getOreSpheroidTypesBasedOnDict(LinkedHashMap<String, ArrayList<class_2680>> dynamicOres) {
        LinkedHashMap<SpheroidType, Float> dynamicSpheroidTypes = new LinkedHashMap<SpheroidType, Float>();
        if (dynamicOres.size() > 0) {
            for (Map.Entry<String, ArrayList<class_2680>> dynamicOre : dynamicOres.entrySet()) {
                class_2680 firstEntry = dynamicOre.getValue().get(0);
                OreSpheroidDefinition entrySpheroidDefinition = dynamicOreSpheroidDefinitions.get(dynamicOre.getKey());
                if (entrySpheroidDefinition == null) {
                    StarrySkyCommon.LOGGER.log(Level.ERROR, "The rarity of ore '" + dynamicOre.getKey() + "' is not defined. Blame the Starry Sky author!");
                    continue;
                }
                dynamicSpheroidTypes.put(new CoreSpheroidType(null, entrySpheroidDefinition.minRadius, entrySpheroidDefinition.maxRadius, firstEntry, entrySpheroidDefinition.shellBlockStates, entrySpheroidDefinition.minCoreRadius, entrySpheroidDefinition.maxCoreRadius), Float.valueOf(entrySpheroidDefinition.generationWeight));
            }
        }
        return dynamicSpheroidTypes;
    }

    private static class OreSpheroidDefinition {
        LinkedHashMap<class_2680, Float> shellBlockStates;
        int minRadius;
        int maxRadius;
        int minCoreRadius;
        int maxCoreRadius;
        float generationWeight;

        public OreSpheroidDefinition(LinkedHashMap<class_2680, Float> shellBlockStates, int minRadius, int maxRadius, int minCoreRadius, int maxCoreRadius, float generationWeight) {
            this.shellBlockStates = shellBlockStates;
            this.minRadius = minRadius;
            this.maxRadius = maxRadius;
            this.minCoreRadius = minCoreRadius;
            this.maxCoreRadius = maxCoreRadius;
            this.generationWeight = generationWeight;
        }
    }
}

