/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.spheroids;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;

public class CaveSpheroid
extends Spheroid {
    private final class_2680 coreBlock = class_2246.field_10543.method_9564();
    private final class_2680 caveFloorBlock;
    private final class_2680 topBlock;
    private final class_2680 bottomBlock;
    private final class_2680 shellBlock;
    private final int shellRadius;
    class_2960 chestLootTable;

    public CaveSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, class_2680 caveFloorBlock, class_2680 shellBlock, int shellRadius, class_2680 topBlock, class_2680 bottomBlock, class_2960 chestLootTable) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.caveFloorBlock = caveFloorBlock;
        this.shellBlock = shellBlock;
        this.shellRadius = shellRadius;
        this.topBlock = topBlock;
        this.bottomBlock = bottomBlock;
        this.chestLootTable = chestLootTable;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        boolean hasChest = this.chestLootTable != null;
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d == (long)this.radius) {
                        if (this.isBottomBlock(d, x2, y2, z2)) {
                            chunk.method_12010(currBlockPos, this.bottomBlock, false);
                            continue;
                        }
                        if (this.isTopBlock(d, x2, y2, z2)) {
                            chunk.method_12010(currBlockPos, this.topBlock, false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, this.shellBlock, false);
                        continue;
                    }
                    if (this.isAboveCaveFloorBlock(d, x2, y2, z2, this.shellRadius)) {
                        chunk.method_12010(currBlockPos.method_10074(), this.caveFloorBlock, false);
                        this.addDecorationBlockPosition(currBlockPos.method_10074());
                        if (!hasChest || x2 - x != 0 || z2 - z != 0) continue;
                        this.placeCenterChestWithLootTable(chunk, currBlockPos, this.chestLootTable, (Random)this.random, false);
                        continue;
                    }
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, this.coreBlock, false);
                        continue;
                    }
                    if (d >= (long)this.radius) continue;
                    chunk.method_12010(currBlockPos, this.shellBlock, false);
                }
            }
        }
    }

    @Override
    public String getDescription() {
        String s = "+++ CaveSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellBlock: " + this.shellBlock + "\nShellRadius: " + this.shellRadius + "\nCaveFloorBlock: " + this.caveFloorBlock;
        if (this.topBlock != null) {
            s = s + "\nTopBlock: " + this.topBlock.toString();
        }
        if (this.bottomBlock != null) {
            s = s + "\nBottomBlock: " + this.bottomBlock.toString();
        }
        return s;
    }
}

