/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.spheroids.unique;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.lists.SpheroidList;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2756;
import net.minecraft.class_2769;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_3233;
import net.minecraft.class_4466;
import net.minecraft.class_4481;
import net.minecraft.class_4482;

public class BeeHiveSpheroid
extends Spheroid {
    private final int shellRadius;
    private final int flowerRingRadius;
    private final int flowerRingSpacing;
    private class_4482 queenBeehiveBlockEntity;
    private final List<class_4482> outerBeehiveBlockEntities;

    public BeeHiveSpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, int shellRadius, int flowerRingRadius, int flowerRingSpacing) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.shellRadius = shellRadius;
        this.flowerRingRadius = flowerRingRadius;
        this.flowerRingSpacing = flowerRingSpacing;
        this.outerBeehiveBlockEntities = new ArrayList<class_4482>();
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        int endRingDistance = this.radius;
        int startRingDistance = this.radius - this.flowerRingRadius;
        int shellDistance = startRingDistance - this.flowerRingSpacing;
        int coreDistance = shellDistance - this.shellRadius;
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    float d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d == 0.0f) {
                        chunk.method_12010(currBlockPos, class_2246.field_20421.method_9564(), false);
                        this.queenBeehiveBlockEntity = new class_4482();
                        chunk.method_12007(currBlockPos, (class_2586)this.queenBeehiveBlockEntity);
                        continue;
                    }
                    if (d == (float)shellDistance && y2 - y == 0 && this.random.nextInt(10) == 0) {
                        int xDist = x2 - x;
                        int zDist = z2 - z;
                        class_2350 direction = xDist > 0 ? (Math.abs(xDist) > Math.abs(zDist) ? class_2350.field_11034 : (zDist > 0 ? class_2350.field_11035 : class_2350.field_11043)) : (Math.abs(xDist) < Math.abs(zDist) ? (zDist > 0 ? class_2350.field_11035 : class_2350.field_11043) : class_2350.field_11039);
                        class_2680 blockState = (class_2680)class_2246.field_20421.method_9564().method_11657((class_2769)class_4481.field_20419, (Comparable)direction);
                        chunk.method_12010(currBlockPos, blockState, false);
                        class_4482 outerBeehiveBlockEntity = new class_4482();
                        chunk.method_12007(currBlockPos, (class_2586)outerBeehiveBlockEntity);
                        this.outerBeehiveBlockEntities.add(outerBeehiveBlockEntity);
                        continue;
                    }
                    if (d <= (float)coreDistance) {
                        int r = this.random.nextInt((int)Math.ceil((float)coreDistance / 3.0f));
                        if ((float)(coreDistance - r) <= d) {
                            chunk.method_12010(currBlockPos, class_2246.field_21211.method_9564(), false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, class_2246.field_10124.method_9564(), false);
                        continue;
                    }
                    if (d <= (float)shellDistance) {
                        if (this.random.nextInt(10) == 0) {
                            chunk.method_12010(currBlockPos, class_2246.field_21211.method_9564(), false);
                            continue;
                        }
                        chunk.method_12010(currBlockPos, class_2246.field_21212.method_9564(), false);
                        continue;
                    }
                    if (y - y2 != 0 || !(d > (float)startRingDistance) || !(d <= (float)endRingDistance)) continue;
                    chunk.method_12010(currBlockPos, class_2246.field_10219.method_9564(), false);
                    int rand = this.random.nextInt(4);
                    if (rand == 0) {
                        chunk.method_12010(currBlockPos.method_10084(), this.getRandomFlower(this.random), false);
                        continue;
                    }
                    if (rand != 1) continue;
                    class_2680 randomTallFlower = this.getRandomTallFlower(this.random);
                    chunk.method_12010(currBlockPos.method_10084(), (class_2680)randomTallFlower.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607), false);
                    chunk.method_12010(currBlockPos.method_10086(2), (class_2680)randomTallFlower.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12609), false);
                }
            }
        }
    }

    public class_2680 getRandomFlower(class_2919 random) {
        return SpheroidList.LIST_FLOWERS.get(random.nextInt(SpheroidList.LIST_FLOWERS.size()));
    }

    public class_2680 getRandomTallFlower(class_2919 random) {
        return SpheroidList.LIST_TALL_FLOWERS.get(random.nextInt(SpheroidList.LIST_TALL_FLOWERS.size()));
    }

    @Override
    public String getDescription() {
        return "+++ BeeHiveSpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellRadius: " + this.shellRadius + "\nFlowerRingRadius: " + this.flowerRingRadius + "\nFlowerRingSpacing: " + this.flowerRingSpacing;
    }

    @Override
    public void populateEntities(class_1923 chunkPos, class_3233 chunkRegion, class_2919 chunkRandom) {
        if (this.shouldPopulateEntities(chunkPos)) {
            if (this.queenBeehiveBlockEntity != null) {
                class_4466 queen = new class_4466(class_1299.field_20346, (class_1937)chunkRegion.method_8410());
                this.setRandomQueenProperties(queen, chunkRandom);
                this.queenBeehiveBlockEntity.method_21848((class_1297)queen, false);
            }
            for (class_4482 beehiveBlockEntity : this.outerBeehiveBlockEntities) {
                class_4466 bee1 = new class_4466(class_1299.field_20346, (class_1937)chunkRegion.method_8410());
                beehiveBlockEntity.method_21848((class_1297)bee1, false);
                class_4466 bee2 = new class_4466(class_1299.field_20346, (class_1937)chunkRegion.method_8410());
                beehiveBlockEntity.method_21848((class_1297)bee2, false);
            }
        }
    }

    public void setRandomQueenProperties(class_4466 beeEntity, class_2919 chunkRandom) {
        beeEntity.method_5665((class_2561)new class_2588("bee.queen"));
        beeEntity.method_6033(beeEntity.method_6032() * (this.random.nextFloat() * 3.0f + 5.0f));
        beeEntity.method_6125((float)((double)beeEntity.method_6029() * ((double)this.random.nextFloat() * 0.5 + 0.5)));
        beeEntity.method_6073((float)((double)beeEntity.method_6067() * ((double)this.random.nextFloat() * 1.5 + 1.0)));
        class_1293 statusEffectInstance1 = new class_1293(class_1294.field_5917, Integer.MAX_VALUE, 1);
        class_1293 statusEffectInstance2 = new class_1293(class_1294.field_5910, Integer.MAX_VALUE, 3);
        class_1293 statusEffectInstance3 = new class_1293(class_1294.field_5924, Integer.MAX_VALUE, 1);
        beeEntity.method_6092(statusEffectInstance1);
        beeEntity.method_6092(statusEffectInstance2);
        beeEntity.method_6092(statusEffectInstance3);
        beeEntity.method_5834(true);
        beeEntity.method_29514(Integer.MAX_VALUE);
    }
}

