/*
 * Decompiled with CFR 0.152.
 */
package de.dafuqs.starrysky.spheroid.spheroids.unique;

import de.dafuqs.starrysky.Support;
import de.dafuqs.starrysky.advancements.SpheroidAdvancementIdentifier;
import de.dafuqs.starrysky.dimension.SpheroidDecorator;
import de.dafuqs.starrysky.spheroid.SpheroidEntitySpawnDefinition;
import de.dafuqs.starrysky.spheroid.spheroids.Spheroid;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_39;
import net.minecraft.class_5281;

public class EndCitySpheroid
extends Spheroid {
    private final class_2680 AIR = class_2246.field_10124.method_9564();
    private final class_2680 PURPUR_BLOCK = class_2246.field_10286.method_9564();
    private final class_2680 PURPUR_PILLAR = class_2246.field_10505.method_9564();
    private final class_2680 MAGENTA_STAINED_GLASS = class_2246.field_10574.method_9564();
    private final class_2680 END_STONE_BRICKS = class_2246.field_10462.method_9564();
    private final class_2680 END_ROD = class_2246.field_10455.method_9564();
    private final class_2680 DRAGON_HEAD = class_2246.field_10337.method_9564();
    private final class_2960 END_CITY_TREASURE_CHEST = class_39.field_274;
    private final int shellRadius;
    private final ArrayList<class_2338> interiorDecoratorPositions = new ArrayList();

    public EndCitySpheroid(class_2919 random, SpheroidAdvancementIdentifier spheroidAdvancementIdentifier, int radius, ArrayList<SpheroidDecorator> spheroidDecorators, ArrayList<SpheroidEntitySpawnDefinition> entityTypesToSpawn, int shellRadius) {
        super(spheroidAdvancementIdentifier, random, spheroidDecorators, radius, entityTypesToSpawn);
        this.shellRadius = shellRadius;
    }

    @Override
    public String getDescription() {
        return "+++ EndCitySpheroid +++\nPosition: x=" + this.getPosition().method_10263() + " y=" + this.getPosition().method_10264() + " z=" + this.getPosition().method_10260() + "\nRadius: " + this.radius + "\nShellRadius: " + this.shellRadius;
    }

    @Override
    public void generate(class_2791 chunk) {
        int chunkX = chunk.method_12004().field_9181;
        int chunkZ = chunk.method_12004().field_9180;
        int x = this.getPosition().method_10263();
        int y = this.getPosition().method_10264();
        int z = this.getPosition().method_10260();
        this.random.setSeed((long)chunkX * 341873128712L + (long)chunkZ * 132897987541L);
        for (int x2 = Math.max(chunkX * 16, x - this.radius); x2 <= Math.min(chunkX * 16 + 15, x + this.radius); ++x2) {
            for (int y2 = y - this.radius; y2 <= y + this.radius; ++y2) {
                for (int z2 = Math.max(chunkZ * 16, z - this.radius); z2 <= Math.min(chunkZ * 16 + 15, z + this.radius); ++z2) {
                    class_2338 currBlockPos = new class_2338(x2, y2, z2);
                    long d = Math.round(Support.getDistance(x, y, z, x2, y2, z2));
                    if (d <= (long)(this.radius - this.shellRadius)) {
                        chunk.method_12010(currBlockPos, this.PURPUR_BLOCK, false);
                    } else if (d <= (long)this.radius) {
                        if (y2 % 2 == 0) {
                            chunk.method_12010(currBlockPos, this.END_STONE_BRICKS, false);
                        } else {
                            chunk.method_12010(currBlockPos, this.PURPUR_BLOCK, false);
                        }
                    }
                    if (d >= (long)(this.getRadius() - 9) || y2 % 10 != (this.position.method_10264() + 9) % 10 || x2 % 10 != this.position.method_10263() % 10 || z2 % 10 != this.position.method_10260() % 10) continue;
                    this.interiorDecoratorPositions.add(currBlockPos);
                }
            }
        }
    }

    @Override
    public void decorate(class_5281 world, Random random) {
        block7: for (class_2338 interiorDecoratorPosition : this.interiorDecoratorPositions) {
            int randomStructure = random.nextInt(7);
            switch (randomStructure) {
                case 0: {
                    this.placeSolid((class_1936)world, interiorDecoratorPosition);
                    continue block7;
                }
                case 1: {
                    this.placeEmpty((class_1936)world, interiorDecoratorPosition);
                    continue block7;
                }
                case 2: {
                    this.placeElytra((class_1936)world, interiorDecoratorPosition);
                    continue block7;
                }
                case 3: {
                    this.placeTreasure((class_1936)world, interiorDecoratorPosition);
                    continue block7;
                }
                case 4: {
                    this.placeBrewingStand((class_1936)world, interiorDecoratorPosition);
                    continue block7;
                }
            }
            this.placeShulkerSpawner((class_1936)world, interiorDecoratorPosition);
        }
    }

    private void placeSolid(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.PURPUR_BLOCK, 3);
                }
            }
        }
    }

    private void placeEmpty(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
    }

    private void placeShulkerSpawner(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        class_2338 spawnerPos = blockPos.method_10086(4);
        for (int x2 = -1; x2 < 2; ++x2) {
            for (int y2 = -1; y2 < 2; ++y2) {
                for (int z2 = -1; z2 < 2; ++z2) {
                    class_2338 destinationBlockPos = spawnerPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.MAGENTA_STAINED_GLASS, 3);
                }
            }
        }
        worldAccess.method_8652(spawnerPos.method_10086(2), this.PURPUR_PILLAR, 3);
        worldAccess.method_8652(spawnerPos.method_10086(3), this.PURPUR_PILLAR, 3);
        worldAccess.method_8652(spawnerPos.method_10086(4), this.PURPUR_PILLAR, 3);
        this.placeSpawner(worldAccess, spawnerPos.method_10084(), class_1299.field_6109);
    }

    private void placeBrewingStand(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        worldAccess.method_8652(blockPos, this.PURPUR_PILLAR, 3);
        worldAccess.method_8652(blockPos.method_10084(), class_2246.field_10333.method_9564(), 3);
    }

    private void placeTreasure(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        class_2680 enderChestBlockState = class_2246.field_10443.method_9564();
        class_2338 randomPos = blockPos.method_10069(this.random.nextInt(9) - 4, 0, this.random.nextInt(9) - 4);
        worldAccess.method_8652(randomPos, enderChestBlockState, 3);
        this.placeCenterChestWithLootTable(worldAccess.method_22350(blockPos), blockPos, this.END_CITY_TREASURE_CHEST, (Random)this.random, false);
    }

    private void placeElytra(class_1936 worldAccess, class_2338 blockPos) {
        for (int x2 = -4; x2 < 5; ++x2) {
            for (int y2 = 0; y2 < 9; ++y2) {
                for (int z2 = -4; z2 < 5; ++z2) {
                    class_2338 destinationBlockPos = blockPos.method_10069(x2, y2, z2);
                    worldAccess.method_8652(destinationBlockPos, this.AIR, 3);
                }
            }
        }
        worldAccess.method_8652(blockPos, this.PURPUR_PILLAR, 3);
        worldAccess.method_8652(blockPos.method_10084(), class_2246.field_10034.method_9564(), 3);
        class_1799 elytraItemStack = new class_1799((class_1935)class_1802.field_8833, 1);
        class_2586 blockEntity = worldAccess.method_8321(blockPos.method_10084());
        if (blockEntity instanceof class_2595) {
            class_2595 chestBlockEntity = (class_2595)blockEntity;
            chestBlockEntity.method_5447(0, elytraItemStack);
        }
    }
}

